/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web;

import cool.scx.common.util.ScxExceptionHelper;
import cool.scx.http.exception.BadRequestException;
import cool.scx.http.routing.Router;
import cool.scx.http.routing.RoutingContext;
import cool.scx.http.routing.WebSocketRouter;
import cool.scx.reflect.ParameterInfo;
import cool.scx.web.RouteRegistrar;
import cool.scx.web.ScxWebOptions;
import cool.scx.web.WebSocketRouteRegistrar;
import cool.scx.web.exception_handler.ExceptionHandler;
import cool.scx.web.exception_handler.LastExceptionHandler;
import cool.scx.web.exception_handler.ScxHttpExceptionHandler;
import cool.scx.web.interceptor.DefaultInterceptor;
import cool.scx.web.interceptor.Interceptor;
import cool.scx.web.parameter_handler.FileUploadParameterHandler;
import cool.scx.web.parameter_handler.FromBodyParameterHandler;
import cool.scx.web.parameter_handler.FromPathParameterHandler;
import cool.scx.web.parameter_handler.FromQueryParameterHandler;
import cool.scx.web.parameter_handler.LastParameterHandler;
import cool.scx.web.parameter_handler.ParameterHandler;
import cool.scx.web.parameter_handler.RequestInfo;
import cool.scx.web.parameter_handler.RoutingContextParameterHandler;
import cool.scx.web.parameter_handler.exception.ParamConvertException;
import cool.scx.web.parameter_handler.exception.RequiredParamEmptyException;
import cool.scx.web.return_value_handler.BaseVoReturnValueHandler;
import cool.scx.web.return_value_handler.LastReturnValueHandler;
import cool.scx.web.return_value_handler.NullReturnValueHandler;
import cool.scx.web.return_value_handler.ReturnValueHandler;
import cool.scx.web.return_value_handler.StringReturnValueHandler;
import cool.scx.web.return_value_handler.TemplateReturnValueHandler;
import cool.scx.web.template.ScxTemplateHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class ScxWeb {
    private static final InheritableThreadLocal<RoutingContext> ROUTING_CONTEXT_THREAD_LOCAL = new InheritableThreadLocal();
    private final List<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();
    private final LastExceptionHandler lastExceptionHandler;
    private final List<ReturnValueHandler> returnValueHandlers = new ArrayList<ReturnValueHandler>();
    private final LastReturnValueHandler lastReturnValueHandler;
    private final List<ParameterHandler> parameterHandlers = new ArrayList<ParameterHandler>();
    private final LastParameterHandler lastParameterHandler;
    private final ScxTemplateHandler templateHandler;
    private final RouterErrorHandler routerErrorHandler;
    private final RouteRegistrar routeRegistrar;
    private final WebSocketRouteRegistrar webSocketRouteRegistrar;
    private Interceptor interceptor = new DefaultInterceptor();

    public ScxWeb() {
        this(new ScxWebOptions());
    }

    public ScxWeb(ScxWebOptions options) {
        this.templateHandler = new ScxTemplateHandler(options.templateRoot());
        this.routerErrorHandler = new RouterErrorHandler(this);
        this.routeRegistrar = new RouteRegistrar(this);
        this.webSocketRouteRegistrar = new WebSocketRouteRegistrar(this);
        this.addExceptionHandler(new ScxHttpExceptionHandler(options.useDevelopmentErrorPage()));
        this.lastExceptionHandler = new LastExceptionHandler(options.useDevelopmentErrorPage());
        this.addReturnValueHandler(new NullReturnValueHandler());
        this.addReturnValueHandler(new StringReturnValueHandler());
        this.addReturnValueHandler(new TemplateReturnValueHandler(this.templateHandler));
        this.addReturnValueHandler(new BaseVoReturnValueHandler());
        this.lastReturnValueHandler = new LastReturnValueHandler();
        this.addParameterHandler(new RoutingContextParameterHandler());
        this.addParameterHandler(new FileUploadParameterHandler());
        this.addParameterHandler(new FromBodyParameterHandler());
        this.addParameterHandler(new FromQueryParameterHandler());
        this.addParameterHandler(new FromPathParameterHandler());
        this.lastParameterHandler = new LastParameterHandler();
    }

    public static RoutingContext routingContext() {
        return (RoutingContext)ROUTING_CONTEXT_THREAD_LOCAL.get();
    }

    static void _routingContext(RoutingContext routingContext) {
        ROUTING_CONTEXT_THREAD_LOCAL.set(routingContext);
    }

    static void _clearRoutingContext() {
        ROUTING_CONTEXT_THREAD_LOCAL.remove();
    }

    public ScxWeb registerHttpRoutes(Router router, Object ... objects) {
        this.routeRegistrar.registerRoute(router, objects);
        return this;
    }

    public ScxWeb registerWebSocketRoutes(WebSocketRouter router, Object ... objects) {
        this.webSocketRouteRegistrar.registerRoute(router, objects);
        return this;
    }

    public ScxWeb setInterceptor(Interceptor newInterceptor) {
        if (newInterceptor == null) {
            throw new IllegalArgumentException("Interceptor must not be empty !!!");
        }
        this.interceptor = newInterceptor;
        return this;
    }

    public ScxWeb addExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.add(exceptionHandler);
        return this;
    }

    public ScxWeb addParameterHandler(ParameterHandler handler) {
        this.parameterHandlers.add(handler);
        return this;
    }

    public ScxWeb addReturnValueHandler(ReturnValueHandler returnValueHandler) {
        this.returnValueHandlers.add(returnValueHandler);
        return this;
    }

    public ScxWeb addExceptionHandler(int index, ExceptionHandler handler) {
        this.exceptionHandlers.add(index, handler);
        return this;
    }

    public ScxWeb addParameterHandler(int index, ParameterHandler handler) {
        this.parameterHandlers.add(index, handler);
        return this;
    }

    public ScxWeb addReturnValueHandler(int index, ReturnValueHandler returnValueHandler) {
        this.returnValueHandlers.add(index, returnValueHandler);
        return this;
    }

    Interceptor interceptor() {
        return this.interceptor;
    }

    public ScxTemplateHandler templateHandler() {
        return this.templateHandler;
    }

    ExceptionHandler findExceptionHandler(Throwable throwable) {
        for (ExceptionHandler handler : this.exceptionHandlers) {
            if (!handler.canHandle(throwable)) continue;
            return handler;
        }
        return this.lastExceptionHandler;
    }

    ReturnValueHandler findReturnValueHandler(Object result) {
        for (ReturnValueHandler handler : this.returnValueHandlers) {
            if (!handler.canHandle(result)) continue;
            return handler;
        }
        return this.lastReturnValueHandler;
    }

    ParameterHandler findParameterHandler(ParameterInfo parameter) {
        for (ParameterHandler handler : this.parameterHandlers) {
            if (!handler.canHandle(parameter)) continue;
            return handler;
        }
        return this.lastParameterHandler;
    }

    Object[] buildMethodParameters(ParameterInfo[] parameters, RoutingContext context) throws Exception {
        RequestInfo info = new RequestInfo(context);
        ArrayList<Exception> exceptionArrayList = new ArrayList<Exception>();
        Object[] methodParameter = new Object[parameters.length];
        for (int i = 0; i < methodParameter.length; ++i) {
            ParameterHandler methodParameterHandler = this.findParameterHandler(parameters[i]);
            try {
                methodParameter[i] = methodParameterHandler.handle(parameters[i], info);
                continue;
            }
            catch (ParamConvertException | RequiredParamEmptyException e) {
                exceptionArrayList.add(e);
            }
        }
        if (!exceptionArrayList.isEmpty()) {
            throw new BadRequestException(exceptionArrayList.stream().map(Throwable::getMessage).collect(Collectors.joining(";" + System.lineSeparator())));
        }
        return methodParameter;
    }

    public ScxWeb bindErrorHandler(Router vertxRouter) {
        vertxRouter.errorHandler((BiConsumer)this.routerErrorHandler);
        return this;
    }

    private record RouterErrorHandler(ScxWeb scxWeb) implements BiConsumer<Throwable, RoutingContext>
    {
        @Override
        public void accept(Throwable throwable, RoutingContext routingContext) {
            Throwable cause = ScxExceptionHelper.getRootCause((Throwable)throwable);
            this.scxWeb.findExceptionHandler(cause).handle(cause, routingContext);
        }
    }
}

