/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.exception_handler;

import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.ScxExceptionHelper;
import cool.scx.common.util.StringUtils;
import cool.scx.http.HttpFieldName;
import cool.scx.http.HttpStatusCode;
import cool.scx.http.MediaType;
import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxMediaType;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.exception.ScxHttpException;
import cool.scx.http.routing.RoutingContext;
import cool.scx.web.exception_handler.ExceptionHandler;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;

public class ScxHttpExceptionHandler
implements ExceptionHandler {
    private static final System.Logger logger = System.getLogger(ScxHttpExceptionHandler.class.getName());
    private static final String htmlTemplate = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>%s</title>\n</head>\n<body>\n    <h1>%s - %s</h1>\n    <hr>\n    <pre>%s</pre>\n</body>\n</html>\n";
    private final boolean useDevelopmentErrorPage;

    public ScxHttpExceptionHandler(boolean useDevelopmentErrorPage) {
        this.useDevelopmentErrorPage = useDevelopmentErrorPage;
    }

    public static void sendToClient(HttpStatusCode statusCode, String info, RoutingContext routingContext) {
        String accept;
        if (info == null) {
            info = "";
        }
        if ((accept = routingContext.request().getHeader((ScxHttpHeaderName)HttpFieldName.ACCEPT)) != null && StringUtils.startsWithIgnoreCase((String)accept, (String)MediaType.TEXT_HTML.value())) {
            String htmlStr = String.format(htmlTemplate, statusCode.description(), statusCode, statusCode.description(), info);
            routingContext.response().contentType((ContentType)ContentType.of((ScxMediaType)MediaType.TEXT_HTML).charset(StandardCharsets.UTF_8)).status(statusCode).send(htmlStr);
        } else {
            LinkedHashMap<String, Object> tempMap = new LinkedHashMap<String, Object>();
            tempMap.put("statusCode", statusCode);
            tempMap.put("title", statusCode.description());
            tempMap.put("info", info);
            String jsonStr = ObjectUtils.toJson(tempMap, (String)"");
            routingContext.response().contentType((ContentType)ContentType.of((ScxMediaType)MediaType.APPLICATION_JSON).charset(StandardCharsets.UTF_8)).status(statusCode).send(jsonStr);
        }
    }

    public void handleScxHttpException(ScxHttpException scxHttpException, RoutingContext routingContext) {
        String info = null;
        if (this.useDevelopmentErrorPage) {
            Throwable cause = ScxExceptionHelper.getRootCause((Throwable)scxHttpException.getCause());
            info = cause == null ? scxHttpException.getMessage() : ScxExceptionHelper.getStackTraceString((Throwable)cause);
        }
        ScxHttpExceptionHandler.sendToClient(scxHttpException.statusCode(), info, routingContext);
    }

    @Override
    public boolean canHandle(Throwable throwable) {
        return throwable instanceof ScxHttpException;
    }

    @Override
    public void handle(Throwable throwable, RoutingContext routingContext) {
        if (!routingContext.response().isClosed()) {
            this.handleScxHttpException((ScxHttpException)throwable, routingContext);
        } else {
            logger.log(System.Logger.Level.ERROR, "\u6355\u83b7\u5230 ScxHttpException \u5f02\u5e38 !!!, \u56e0\u4e3a\u8bf7\u6c42\u5df2\u88ab\u76f8\u5e94, \u6240\u4ee5\u9519\u8bef\u4fe1\u606f\u53ef\u80fd\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u7ed9\u5ba2\u6237\u7aef !!!", throwable);
        }
    }
}

