/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web;

import cool.scx.common.util.ClassUtils;
import cool.scx.common.util.URIBuilder;
import cool.scx.http.routing.WebSocketRoute;
import cool.scx.http.routing.WebSocketRouter;
import cool.scx.http.routing.WebSocketRoutingContext;
import cool.scx.web.BaseWebSocketHandler;
import cool.scx.web.ScxWeb;
import cool.scx.web.annotation.ScxWebSocketRoute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class WebSocketRouteRegistrar {
    private static final Comparator<WebSocketRoute> orderComparator = Comparator.comparing(WebSocketRoute::order);
    private final ScxWeb scxWeb;

    public WebSocketRouteRegistrar(ScxWeb scxWeb) {
        this.scxWeb = scxWeb;
    }

    private static List<WebSocketRoute> initWebSocketRoutes(Object ... objects) {
        List<BaseWebSocketHandler> filteredObjectList = WebSocketRouteRegistrar.filterObject(objects);
        List<WebSocketRoute> routeList = filteredObjectList.stream().map(WebSocketRouteRegistrar::createWebSocketRoute).toList();
        return WebSocketRouteRegistrar.sortedWebSocketRoutes(routeList);
    }

    public static WebSocketRoute createWebSocketRoute(BaseWebSocketHandler o) {
        Class<?> c = o.getClass();
        ScxWebSocketRoute scxWebSocketMapping = c.getAnnotation(ScxWebSocketRoute.class);
        String path = URIBuilder.addSlashStart((String)URIBuilder.join((String[])new String[]{scxWebSocketMapping.value()}));
        int order = scxWebSocketMapping.order();
        return WebSocketRoute.of().order(order).path(path).handler(d -> {
            try {
                o.onOpen((WebSocketRoutingContext)d);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static List<BaseWebSocketHandler> filterObject(Object ... classList) {
        return Arrays.stream(classList).filter(o -> WebSocketRouteRegistrar.isWebSocketRouteClass(o.getClass())).map(c -> (BaseWebSocketHandler)c).toList();
    }

    public static List<? extends Class<? extends BaseWebSocketHandler>> filterClass(List<Class<?>> classList) {
        return classList.stream().filter(WebSocketRouteRegistrar::isWebSocketRouteClass).map(c -> c).toList();
    }

    public static boolean isWebSocketRouteClass(Class<?> c) {
        return c.isAnnotationPresent(ScxWebSocketRoute.class) && ClassUtils.isNormalClass(c) && BaseWebSocketHandler.class.isAssignableFrom(c);
    }

    private static List<WebSocketRoute> sortedWebSocketRoutes(List<WebSocketRoute> list) {
        return list.stream().sorted(orderComparator).toList();
    }

    public WebSocketRouter registerRoute(WebSocketRouter scxWebSocketRouter, Object ... objects) {
        List<WebSocketRoute> routes = WebSocketRouteRegistrar.initWebSocketRoutes(objects);
        for (WebSocketRoute route : routes) {
            scxWebSocketRouter.addRoute(route);
        }
        return scxWebSocketRouter;
    }
}

