/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.parameter_handler.from_body;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import cool.scx.common.util.AnnotationUtils;
import cool.scx.common.util.JsonNodeHelper;
import cool.scx.common.util.ObjectUtils;
import cool.scx.reflect.ParameterInfo;
import cool.scx.web.annotation.FromBody;
import cool.scx.web.parameter_handler.ParameterHandler;
import cool.scx.web.parameter_handler.RequestInfo;
import cool.scx.web.parameter_handler.exception.ParamConvertException;
import cool.scx.web.parameter_handler.exception.RequiredParamEmptyException;
import java.io.IOException;

public final class FromBodyParameterHandler
implements ParameterHandler {
    private final FromBody fromBody;
    private final ParameterInfo parameter;
    private final String value;

    public FromBodyParameterHandler(FromBody fromBody, ParameterInfo parameter) {
        this.fromBody = fromBody;
        this.parameter = parameter;
        String tempValue = AnnotationUtils.getAnnotationValue((String)fromBody.value());
        this.value = tempValue != null ? tempValue : parameter.name();
    }

    public static Object getValueFromBody(String name, boolean useAllBody, boolean required, JavaType javaType, RequestInfo info) throws RequiredParamEmptyException, ParamConvertException {
        return FromBodyParameterHandler.fromBody(name, useAllBody, required, javaType, info);
    }

    private static Object fromBody(String name, boolean useAllBody, boolean required, JavaType javaType, RequestInfo info) throws RequiredParamEmptyException, ParamConvertException {
        Object o;
        JsonNode tempValue;
        JsonNode jsonNode = tempValue = useAllBody ? info.body() : JsonNodeHelper.get((JsonNode)info.body(), (String)name);
        if (tempValue == null || tempValue.isNull() || tempValue.isMissingNode()) {
            if (required) {
                throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "]");
            }
            return null;
        }
        try {
            o = FromBodyParameterHandler.readValue(tempValue, javaType);
        }
        catch (Exception e) {
            throw new ParamConvertException("\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38 !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "] , \u8be6\u7ec6\u9519\u8bef\u4fe1\u606f : " + e.getMessage());
        }
        if (o == null && required) {
            throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "]");
        }
        return o;
    }

    public static <T> T readValue(JsonNode jsonNode, JavaType type) throws IOException {
        ObjectReader reader = ObjectUtils.jsonMapper((ObjectUtils.Options)new ObjectUtils.Options().setIgnoreJsonIgnore(true)).readerFor(type);
        if (jsonNode.isArray()) {
            if (type.isArrayType() || type.isCollectionLikeType()) {
                return (T)reader.readValue(jsonNode);
            }
            return (T)reader.readValue(jsonNode.get(0));
        }
        if (type.isArrayType() || type.isCollectionLikeType()) {
            ArrayNode add = ObjectUtils.jsonMapper().createArrayNode().add(jsonNode);
            return (T)reader.readValue((JsonNode)add);
        }
        return (T)reader.readValue(jsonNode);
    }

    @Override
    public Object handle(RequestInfo requestInfo) throws Exception {
        return FromBodyParameterHandler.getValueFromBody(this.value, this.fromBody.useAllBody(), this.fromBody.required(), this.parameter.type(), requestInfo);
    }
}

