/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.vo;

import cool.scx.http.FileFormat;
import cool.scx.http.HttpFieldName;
import cool.scx.http.MediaType;
import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxMediaType;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.exception.BadRequestException;
import cool.scx.http.exception.NotFoundException;
import cool.scx.http.routing.RoutingContext;
import cool.scx.http.routing.handler.StaticHelper;
import cool.scx.web.vo.BaseVo;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.AbsoluteSize;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Size;

public abstract class Image
implements BaseVo {
    protected Image(Path _file) {
        Objects.requireNonNull(_file, "\u56fe\u7247\u6587\u4ef6\u4e0d\u80fd\u4e3a null");
        if (Files.notExists(_file, new LinkOption[0])) {
            throw new NotFoundException();
        }
    }

    public static Image of(Path file) {
        return Image.of(file, null, null, null);
    }

    public static Image of(Path file, Integer width, Integer height, Position position) {
        FileFormat fileFormat = FileFormat.findByFileName((String)file.toString());
        if (fileFormat != null && fileFormat.mediaType().type().equals("image")) {
            if (height == null && width == null) {
                return new OriginalImage(file);
            }
            return new CroppedImage(file, width, height, position);
        }
        return new SystemIconImage(file);
    }

    public final void accept(RoutingContext context) throws BadRequestException {
        context.response().setHeader((ScxHttpHeaderName)HttpFieldName.CACHE_CONTROL, new String[]{"public,immutable,max-age=2628000"}).setHeader((ScxHttpHeaderName)HttpFieldName.ACCEPT_RANGES, new String[]{"bytes"});
        this.imageHandler(context);
    }

    public abstract void imageHandler(RoutingContext var1);

    private static final class OriginalImage
    extends Image {
        private final Path filePath;

        public OriginalImage(Path file) {
            super(file);
            this.filePath = file;
        }

        @Override
        public void imageHandler(RoutingContext context) {
            StaticHelper.sendStatic((Path)this.filePath, (RoutingContext)context);
        }
    }

    private static final class CroppedImage
    extends Image {
        private final String contentType;
        private final byte[] buffer;

        public CroppedImage(Path file, Integer width, Integer height, Position position) {
            super(file);
            FileFormat fileFormat = FileFormat.findByFileName((String)file.toString());
            MediaType mediaType = fileFormat != null ? fileFormat.mediaType() : MediaType.APPLICATION_OCTET_STREAM;
            this.contentType = mediaType.value();
            this.buffer = this.getBuffer(file, width, height, position);
        }

        private byte[] getBuffer(Path file, Integer width, Integer height, Position position) {
            byte[] byArray;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                BufferedImage image = Thumbnails.of((File[])new File[]{file.toFile()}).scale(1.0).asBufferedImage();
                int imageHeight = image.getHeight();
                int imageWidth = image.getWidth();
                int croppedHeight = height == null || height > imageHeight || height <= 0 ? imageHeight : height;
                int croppedWidth = width == null || width > imageHeight || width <= 0 ? imageWidth : width;
                AbsoluteSize absoluteSize = new AbsoluteSize(croppedWidth, croppedHeight);
                if (position != null) {
                    Thumbnails.of((File[])new File[]{file.toFile()}).sourceRegion(position, (Size)absoluteSize).size(croppedWidth, croppedHeight).keepAspectRatio(false).toOutputStream((OutputStream)out);
                } else {
                    Thumbnails.of((File[])new File[]{file.toFile()}).size(croppedWidth, croppedHeight).keepAspectRatio(false).toOutputStream((OutputStream)out);
                }
                byArray = out.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BadRequestException((Throwable)e);
                }
            }
            out.close();
            return byArray;
        }

        @Override
        public void imageHandler(RoutingContext context) {
            context.response().contentType((ContentType)ContentType.of((String)this.contentType)).send(this.buffer);
        }
    }

    private static final class SystemIconImage
    extends Image {
        private final byte[] buffer;

        public SystemIconImage(Path file) {
            super(file);
            this.buffer = this.getBuffer(file);
        }

        private byte[] getBuffer(Path file) {
            byte[] byArray;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                java.awt.Image image = ((ImageIcon)FileSystemView.getFileSystemView().getSystemIcon(file.toFile())).getImage();
                BufferedImage myImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics2D g = myImage.createGraphics();
                g.drawImage(image, 0, 0, null);
                g.dispose();
                ImageIO.write((RenderedImage)myImage, "png", out);
                byArray = out.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BadRequestException((Throwable)e);
                }
            }
            out.close();
            return byArray;
        }

        @Override
        public void imageHandler(RoutingContext context) {
            context.response().contentType((ContentType)ContentType.of((ScxMediaType)MediaType.IMAGE_PNG)).send(this.buffer);
        }
    }
}

