/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web;

import cool.scx.common.constant.AnnotationValueHelper;
import cool.scx.common.exception.ScxExceptionHelper;
import cool.scx.common.exception.ScxRuntimeException;
import cool.scx.common.util.CaseUtils;
import cool.scx.common.util.URIUtils;
import cool.scx.http.HttpMethod;
import cool.scx.http.ScxHttpMethod;
import cool.scx.http.routing.MethodMatcher;
import cool.scx.http.routing.PathMatcher;
import cool.scx.http.routing.Route;
import cool.scx.http.routing.RoutingContext;
import cool.scx.http.routing.TypeMatcher;
import cool.scx.reflect.MethodInfo;
import cool.scx.web.RouteRegistrar;
import cool.scx.web.ScxWeb;
import cool.scx.web.annotation.ScxRoute;
import cool.scx.web.parameter_handler.ParameterHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.function.Consumer;

public final class ScxRouteHandler
implements Route,
Consumer<RoutingContext> {
    public final MethodInfo method;
    public final boolean isVoid;
    public final Object instance;
    public final Class<?> clazz;
    private final ScxWeb scxWeb;
    private final String path;
    private final Set<HttpMethod> methods;
    private final int order;
    private final TypeMatcher typeMatcher;
    private final PathMatcher pathMatcher;
    private final MethodMatcher methodMatcher;
    private final ParameterHandler[] parameterHandlers;

    ScxRouteHandler(MethodInfo method, Object instance, ScxWeb scxWeb) {
        this.scxWeb = scxWeb;
        this.clazz = instance.getClass();
        this.method = method;
        this.method.setAccessible(true);
        this.isVoid = method.returnType().getRawClass() == Void.TYPE;
        this.instance = instance;
        ScxRoute clazzAnnotation = this.clazz.getAnnotation(ScxRoute.class);
        ScxRoute methodAnnotation = RouteRegistrar.findScxRouteOrThrow(method);
        this.path = this.initPath(clazzAnnotation, methodAnnotation);
        this.methods = Set.of(methodAnnotation.methods());
        this.order = methodAnnotation.order();
        this.typeMatcher = TypeMatcher.normal();
        this.pathMatcher = this.path.isBlank() ? PathMatcher.any() : PathMatcher.of((String)this.path);
        this.methodMatcher = this.methods.isEmpty() ? MethodMatcher.any() : MethodMatcher.of((ScxHttpMethod[])((ScxHttpMethod[])this.methods.toArray(ScxHttpMethod[]::new)));
        this.parameterHandlers = scxWeb.buildParameterHandlers(this.method.parameters());
    }

    private String initPath(ScxRoute classAnnotation, ScxRoute methodAnnotation) {
        String value;
        String classUrl = "";
        String methodUrl = "";
        if (classAnnotation != null && !methodAnnotation.ignoreParentUrl() && (value = AnnotationValueHelper.getRealValue((String)classAnnotation.value())) != null) {
            classUrl = value;
        }
        if ((value = AnnotationValueHelper.getRealValue((String)methodAnnotation.value())) != null) {
            methodUrl = value;
        } else if (methodAnnotation.useNameAsUrl()) {
            methodUrl = CaseUtils.toKebab((String)this.method.name());
        }
        return URIUtils.addSlashStart((String)URIUtils.join((String[])new String[]{classUrl, methodUrl}));
    }

    @Override
    public void accept(RoutingContext context) {
        ScxWeb._routingContext(context);
        try {
            this.scxWeb.interceptor().preHandle(context, this);
            Object[] methodParameters = this.scxWeb.buildMethodParameters(this.parameterHandlers, context);
            Object tempResult = this.method.method().invoke(this.instance, methodParameters);
            Object finalResult = this.scxWeb.interceptor().postHandle(context, this, tempResult);
            if (!this.isVoid && !context.response().isClosed()) {
                this.scxWeb.findReturnValueHandler(finalResult).handle(finalResult, context);
            }
        }
        catch (Throwable e) {
            Throwable exception = ScxExceptionHelper.getRootCause((Throwable)(e instanceof InvocationTargetException ? e.getCause() : e));
            throw new ScxRuntimeException(exception);
        }
    }

    public String path() {
        return this.path;
    }

    public Set<HttpMethod> methods() {
        return this.methods;
    }

    public TypeMatcher typeMatcher() {
        return this.typeMatcher;
    }

    public PathMatcher pathMatcher() {
        return this.pathMatcher;
    }

    public MethodMatcher methodMatcher() {
        return this.methodMatcher;
    }

    public int order() {
        return this.order;
    }

    public Consumer<RoutingContext> handler() {
        return this;
    }
}

