/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web;

import cool.scx.common.util.ClassUtils;
import cool.scx.common.util.URIUtils;
import cool.scx.http.routing.Route;
import cool.scx.http.routing.Router;
import cool.scx.http.routing.TypeMatcher;
import cool.scx.http.web_socket.ScxServerWebSocket;
import cool.scx.http.web_socket.ScxServerWebSocketHandshakeRequest;
import cool.scx.web.BaseWebSocketHandler;
import cool.scx.web.ScxWeb;
import cool.scx.web.annotation.ScxWebSocketRoute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class WebSocketRouteRegistrar {
    private static final Comparator<Route> orderComparator = Comparator.comparing(Route::order);
    private final ScxWeb scxWeb;

    public WebSocketRouteRegistrar(ScxWeb scxWeb) {
        this.scxWeb = scxWeb;
    }

    private static List<Route> initWebSocketRoutes(Object ... objects) {
        List<BaseWebSocketHandler> filteredObjectList = WebSocketRouteRegistrar.filterObject(objects);
        List<Route> routeList = filteredObjectList.stream().map(WebSocketRouteRegistrar::createWebSocketRoute).toList();
        return WebSocketRouteRegistrar.sortedWebSocketRoutes(routeList);
    }

    public static Route createWebSocketRoute(BaseWebSocketHandler o) {
        Class<?> c = o.getClass();
        ScxWebSocketRoute scxWebSocketMapping = c.getAnnotation(ScxWebSocketRoute.class);
        String path = URIUtils.addSlashStart((String)URIUtils.join((String[])new String[]{scxWebSocketMapping.value()}));
        int order = scxWebSocketMapping.order();
        return Route.of().type(TypeMatcher.Type.WEB_SOCKET_HANDSHAKE).order(order).path(path).handler(d -> {
            try {
                ScxServerWebSocketHandshakeRequest request = (ScxServerWebSocketHandshakeRequest)d.request();
                ScxServerWebSocket ws = request.webSocket();
                o.onOpen(ws);
                ws.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static List<BaseWebSocketHandler> filterObject(Object ... classList) {
        return Arrays.stream(classList).filter(o -> WebSocketRouteRegistrar.isWebSocketRouteClass(o.getClass())).map(c -> (BaseWebSocketHandler)c).toList();
    }

    public static List<? extends Class<? extends BaseWebSocketHandler>> filterClass(List<Class<?>> classList) {
        return classList.stream().filter(WebSocketRouteRegistrar::isWebSocketRouteClass).map(c -> c).toList();
    }

    public static boolean isWebSocketRouteClass(Class<?> c) {
        return c.isAnnotationPresent(ScxWebSocketRoute.class) && ClassUtils.isNormalClass(c) && BaseWebSocketHandler.class.isAssignableFrom(c);
    }

    private static List<Route> sortedWebSocketRoutes(List<Route> list) {
        return list.stream().sorted(orderComparator).toList();
    }

    public Router registerRoute(Router scxWebSocketRouter, Object ... objects) {
        List<Route> routes = WebSocketRouteRegistrar.initWebSocketRoutes(objects);
        for (Route route : routes) {
            scxWebSocketRouter.addRoute(route);
        }
        return scxWebSocketRouter;
    }
}

