/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.return_value_handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.StringUtils;
import cool.scx.http.HttpFieldName;
import cool.scx.http.MediaType;
import cool.scx.http.ScxHttpHeaderName;
import cool.scx.http.ScxMediaType;
import cool.scx.http.content_type.ContentType;
import cool.scx.http.routing.RoutingContext;
import cool.scx.web.return_value_handler.ReturnValueHandler;
import java.nio.charset.StandardCharsets;

public final class LastReturnValueHandler
implements ReturnValueHandler {
    @Override
    public boolean canHandle(Object returnValue) {
        return true;
    }

    @Override
    public void handle(Object returnValue, RoutingContext routingContext) throws JsonProcessingException {
        String accept = routingContext.request().getHeader((ScxHttpHeaderName)HttpFieldName.ACCEPT);
        if (accept != null && StringUtils.startsWithIgnoreCase((String)accept, (String)MediaType.APPLICATION_XML.value())) {
            routingContext.response().contentType((ContentType)ContentType.of((ScxMediaType)MediaType.APPLICATION_XML).charset(StandardCharsets.UTF_8)).send(ObjectUtils.toXml((Object)returnValue));
        } else {
            routingContext.request().response().contentType((ContentType)ContentType.of((ScxMediaType)MediaType.APPLICATION_JSON).charset(StandardCharsets.UTF_8)).send(ObjectUtils.toJson((Object)returnValue));
        }
    }
}

