/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.vo;

import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.headers.HttpFieldName;
import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.routing.RoutingContext;
import cool.scx.http.routing.handler.StaticHelper;
import cool.scx.web.vo.BaseVo;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

class BaseWriter
implements BaseVo {
    protected final InputStream inputStream;
    protected final Path path;
    protected final byte[] bytes;
    protected final Type type;
    protected final MediaType contentType;
    protected final String contentDisposition;

    private BaseWriter(InputStream inputStream, Path path, byte[] bytes, Type type, MediaType contentType, String contentDisposition) {
        this.inputStream = inputStream;
        this.path = path;
        this.bytes = bytes;
        this.type = type;
        this.contentType = contentType;
        this.contentDisposition = contentDisposition;
    }

    protected BaseWriter(InputStream inputStream, MediaType contentType, String contentDisposition) {
        this(inputStream, null, null, Type.INPUT_STREAM, contentType, contentDisposition);
    }

    protected BaseWriter(Path path, MediaType contentType, String contentDisposition) {
        this(null, path, null, Type.PATH, contentType, contentDisposition);
    }

    protected BaseWriter(byte[] bytes, MediaType contentType, String contentDisposition) {
        this(null, null, bytes, Type.BYTE_ARRAY, contentType, contentDisposition);
    }

    public static ScxHttpServerResponse fillContentType(ScxHttpServerResponse response, MediaType contentType) {
        if (contentType == null) {
            return response.contentType((ScxMediaType)MediaType.APPLICATION_OCTET_STREAM);
        }
        if (contentType.type().equals("text") && contentType.charset() == null) {
            return response.contentType((ScxMediaType)ScxMediaType.of((ScxMediaType)contentType).charset(StandardCharsets.UTF_8));
        }
        return response.contentType((ScxMediaType)contentType);
    }

    public final void accept(RoutingContext context) {
        ScxHttpServerResponse response = context.response();
        response.setHeader((ScxHttpHeaderName)HttpFieldName.CONTENT_DISPOSITION, new String[]{this.contentDisposition});
        BaseWriter.fillContentType(response, this.contentType);
        switch (this.type.ordinal()) {
            case 2: {
                response.send(this.bytes);
                break;
            }
            case 0: {
                StaticHelper.sendStatic((Path)this.path, (RoutingContext)context);
                break;
            }
            case 1: {
                response.send(this.inputStream);
            }
        }
    }

    static enum Type {
        PATH,
        INPUT_STREAM,
        BYTE_ARRAY;

    }
}

