/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.parameter_handler.from_upload;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.common.constant.AnnotationValueHelper;
import cool.scx.common.multi_map.MultiMap;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.media.multi_part.MultiPartPart;
import cool.scx.reflect.ParameterInfo;
import cool.scx.web.annotation.FromUpload;
import cool.scx.web.parameter_handler.ParameterHandler;
import cool.scx.web.parameter_handler.RequestInfo;
import cool.scx.web.parameter_handler.exception.RequiredParamEmptyException;
import java.util.Collection;
import java.util.Collections;

public final class FromUploadParameterHandler
implements ParameterHandler {
    private final boolean isCollection;
    private final boolean isArray;
    private final ParameterInfo parameter;
    private String value;
    private boolean required;

    public FromUploadParameterHandler(ParameterInfo parameter) {
        this.parameter = parameter;
        this.value = parameter.name();
        this.required = false;
        FromUpload fromUpload = (FromUpload)parameter.findAnnotation(FromUpload.class);
        if (fromUpload != null) {
            String _value = AnnotationValueHelper.getRealValue((String)fromUpload.value());
            if (_value != null) {
                this.value = _value;
            }
            this.required = fromUpload.required();
        }
        this.isCollection = parameter.type().isCollectionLikeType();
        this.isArray = parameter.type().isArrayType();
    }

    private static MultiPartPart[] findFileUploadListByName(RequestInfo routingContext, String name) {
        MultiMap<String, MultiPartPart> fileUploads = routingContext.uploadFiles();
        return (MultiPartPart[])fileUploads.getAll((Object)name).toArray(MultiPartPart[]::new);
    }

    @Override
    public Object handle(RequestInfo requestInfo) throws RequiredParamEmptyException {
        MultiPartPart[] v = FromUploadParameterHandler.findFileUploadListByName(requestInfo, this.value);
        if (v.length == 0) {
            if (this.required) {
                throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + this.value + "] , \u53c2\u6570\u6765\u6e90 [FromUpload] , \u53c2\u6570\u7c7b\u578b [" + String.valueOf(this.parameter.type()) + "]");
            }
            return null;
        }
        if (this.isArray) {
            return v;
        }
        if (this.isCollection) {
            Collection list = (Collection)ObjectUtils.convertValue((Object)new Object[0], (JavaType)this.parameter.type());
            Collections.addAll(list, v);
            return list;
        }
        return v[0];
    }
}

