/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web;

import cool.scx.common.util.StringUtils;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.media_type.FileFormat;
import cool.scx.http.media_type.MediaType;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class HttpHelper {
    public static String getRequestIP(ScxHttpServerRequest request) {
        String[] s;
        String xRealIPStr = request.getHeader("X-Real-IP");
        if (StringUtils.notBlank((String)xRealIPStr) && !"unknown".equalsIgnoreCase(xRealIPStr)) {
            return xRealIPStr;
        }
        String xForwardedForStr = request.getHeader("X-Forwarded-For");
        if (StringUtils.notBlank((String)xForwardedForStr) && !"unknown".equalsIgnoreCase(xForwardedForStr) && (s = xForwardedForStr.split(",")).length > 0) {
            return s[0];
        }
        String remoteAddressStr = request.remotePeer().address().toString();
        if ("0:0:0:0:0:0:0:1".equals(remoteAddressStr)) {
            return "127.0.0.1";
        }
        return remoteAddressStr;
    }

    public static String getDownloadContentDisposition(String downloadName) {
        return "attachment; filename*=utf-8''" + URLEncoder.encode(downloadName, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public static MediaType getMediaTypeByExtension(String ext) {
        FileFormat fileFormat = FileFormat.findByExtension((String)ext);
        return fileFormat != null ? fileFormat.mediaType() : null;
    }

    public static MediaType getMediaTypeByFileName(String filename) {
        FileFormat fileFormat = FileFormat.findByFileName((String)filename);
        return fileFormat != null ? fileFormat.mediaType() : null;
    }
}

