/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.vo;

import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.routing.RoutingContext;
import cool.scx.web.vo.BaseVo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public final class Html
implements BaseVo {
    private final boolean usePath;
    private final Path htmlPath;
    private final String htmlStr;

    private Html(Path htmlPath, String htmlStr, boolean usePath) {
        this.htmlPath = htmlPath;
        this.htmlStr = htmlStr;
        this.usePath = usePath;
    }

    public static Html of(String htmlStr) {
        return new Html(null, htmlStr, false);
    }

    public static Html of(Path htmlPath) throws IOException {
        return new Html(htmlPath, null, true);
    }

    public void accept(RoutingContext context) throws Exception {
        if (this.usePath) {
            this.sendHtmlPath(context);
        } else {
            this.sendHtmlStr(context);
        }
    }

    public void sendHtmlStr(RoutingContext context) {
        ((ScxHttpServerResponse)context.response().contentType((ScxMediaType)ScxMediaType.of((ScxMediaType)MediaType.TEXT_HTML).charset(StandardCharsets.UTF_8))).send(this.htmlStr);
    }

    public void sendHtmlPath(RoutingContext context) {
        ((ScxHttpServerResponse)context.response().contentType((ScxMediaType)ScxMediaType.of((ScxMediaType)MediaType.TEXT_HTML).charset(StandardCharsets.UTF_8))).send(this.htmlPath);
    }
}

