/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.exception_handler;

import cool.scx.common.util.ExceptionUtils;
import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.exception.ScxHttpException;
import cool.scx.http.headers.accept.Accept;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.routing.RoutingContext;
import cool.scx.http.status.ScxHttpStatus;
import cool.scx.http.status.ScxHttpStatusHelper;
import cool.scx.web.exception_handler.ExceptionHandler;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;

public class ScxHttpExceptionHandler
implements ExceptionHandler {
    private static final System.Logger logger = System.getLogger(ScxHttpExceptionHandler.class.getName());
    private static final String htmlTemplate = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>%s</title>\n</head>\n<body>\n    <h1>%s - %s</h1>\n    <hr>\n    <pre>%s</pre>\n</body>\n</html>\n";
    private final boolean useDevelopmentErrorPage;

    public ScxHttpExceptionHandler(boolean useDevelopmentErrorPage) {
        this.useDevelopmentErrorPage = useDevelopmentErrorPage;
    }

    public static void sendToClient(ScxHttpStatus status, String info, RoutingContext routingContext) {
        if (info == null) {
            info = "";
        }
        String reasonPhrase = ScxHttpStatusHelper.getReasonPhrase((ScxHttpStatus)status, (String)"unknown");
        Accept accepts = routingContext.request().headers().accept();
        if (accepts != null && accepts.contains((ScxMediaType)MediaType.TEXT_HTML)) {
            String htmlStr = String.format(htmlTemplate, reasonPhrase, status.code(), reasonPhrase, info);
            ((ScxHttpServerResponse)routingContext.response().contentType((ScxMediaType)ScxMediaType.of((ScxMediaType)MediaType.TEXT_HTML).charset(StandardCharsets.UTF_8))).status(status).send(htmlStr);
        } else {
            LinkedHashMap<String, Object> tempMap = new LinkedHashMap<String, Object>();
            tempMap.put("status", status);
            tempMap.put("title", reasonPhrase);
            tempMap.put("info", info);
            routingContext.response().status(status).send(tempMap);
        }
    }

    public void handleScxHttpException(ScxHttpException scxHttpException, RoutingContext routingContext) {
        String info = null;
        if (this.useDevelopmentErrorPage) {
            Throwable cause = scxHttpException.getCause();
            info = cause == null ? scxHttpException.getMessage() : ExceptionUtils.getStackTraceString((Throwable)cause);
        }
        ScxHttpExceptionHandler.sendToClient(scxHttpException.status(), info, routingContext);
    }

    @Override
    public boolean canHandle(Throwable throwable) {
        return throwable instanceof ScxHttpException;
    }

    @Override
    public void handle(Throwable throwable, RoutingContext routingContext) {
        if (!routingContext.response().isSent()) {
            this.handleScxHttpException((ScxHttpException)throwable, routingContext);
        } else {
            logger.log(System.Logger.Level.ERROR, "\u6355\u83b7\u5230 ScxHttpException \u5f02\u5e38 !!!, \u56e0\u4e3a\u8bf7\u6c42\u5df2\u88ab\u76f8\u5e94, \u6240\u4ee5\u9519\u8bef\u4fe1\u606f\u53ef\u80fd\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u7ed9\u5ba2\u6237\u7aef !!!", throwable);
        }
    }
}

