/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.parameter_handler;

import cool.scx.collections.multi_map.MultiMap;
import cool.scx.http.media.form_params.FormParams;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartPart;
import cool.scx.http.media.multi_part.MultiPartPartImpl;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.routing.RoutingContext;
import cool.scx.object.ScxObject;
import cool.scx.object.node.Node;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.node.TextNode;
import cool.scx.object.parser.NodeParseException;
import java.io.IOException;

public final class RequestInfo {
    private final RoutingContext routingContext;
    private final ScxMediaType contentType;
    private final ObjectNode pathParams;
    private final ObjectNode query;
    private final boolean cachedMultiPart;
    private Node body;
    private MultiMap<String, MultiPartPart> uploadFiles;
    private boolean bodyInit;

    public RequestInfo(RoutingContext ctx, boolean cachedMultiPart) {
        this.routingContext = ctx;
        this.cachedMultiPart = cachedMultiPart;
        this.contentType = ctx.request().contentType();
        this.pathParams = (ObjectNode)ScxObject.valueToNode((Object)ctx.pathParams().toMultiValueMap());
        this.query = (ObjectNode)ScxObject.valueToNode((Object)ctx.request().query().toMultiValueMap());
        this.bodyInit = false;
    }

    public static Node tryReadOrTextNode(String str) {
        try {
            return ScxObject.fromJson((String)str);
        }
        catch (NodeParseException exception) {
            try {
                return ScxObject.fromXml((String)str);
            }
            catch (NodeParseException e) {
                return new TextNode(str);
            }
        }
    }

    private void initBody(RoutingContext ctx, ScxMediaType contentType) {
        this.bodyInit = true;
        if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType) || MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
            this.body = ctx.request().body().asTree();
            return;
        }
        if (MediaType.APPLICATION_X_WWW_FORM_URLENCODED.equalsIgnoreParams(contentType)) {
            FormParams formParams = ctx.request().body().asFormParams();
            this.body = ScxObject.valueToNode((Object)formParams.toMultiValueMap());
            return;
        }
        if (MediaType.MULTIPART_FORM_DATA.equalsIgnoreParams(contentType)) {
            MultiMap m = new MultiMap();
            MultiMap f = new MultiMap();
            MultiPart multiPart = ctx.request().body().asMultiPart();
            for (MultiPartPart multiPartPart : multiPart) {
                if (multiPartPart.filename() == null) {
                    m.add((Object)multiPartPart.name(), (Object)multiPartPart.asString());
                }
                try {
                    byte[] bytes = multiPartPart.inputStream().readAllBytes();
                    f.add((Object)multiPartPart.name(), (Object)new MultiPartPartImpl().headers(multiPartPart.headers()).body(bytes));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.body = ScxObject.valueToNode((Object)m.toMultiValueMap());
            this.uploadFiles = f;
            return;
        }
        String string = ctx.request().body().asString();
        this.body = string != null ? RequestInfo.tryReadOrTextNode(string) : null;
    }

    public ObjectNode pathParams() {
        return this.pathParams;
    }

    public ObjectNode query() {
        return this.query;
    }

    public Node body() {
        if (!this.bodyInit) {
            this.initBody(this.routingContext, this.contentType);
        }
        return this.body;
    }

    public MultiMap<String, MultiPartPart> uploadFiles() {
        if (!this.bodyInit) {
            this.initBody(this.routingContext, this.contentType);
        }
        return this.uploadFiles;
    }

    public ScxMediaType contentType() {
        return this.contentType;
    }

    public RoutingContext routingContext() {
        return this.routingContext;
    }
}

