/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.websocket.x;

import cool.scx.common.util.Base64Utils;
import cool.scx.common.util.RandomUtils;
import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.headers.HttpFieldName;
import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.empty.EmptyWriter;
import cool.scx.http.sender.HttpSendException;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.http.version.HttpVersion;
import cool.scx.http.x.HttpClient;
import cool.scx.http.x.http1.Http1ClientConnection;
import cool.scx.http.x.http1.Http1ClientRequest;
import cool.scx.http.x.http1.headers.Http1Headers;
import cool.scx.http.x.http1.headers.connection.Connection;
import cool.scx.http.x.http1.headers.upgrade.ScxUpgrade;
import cool.scx.http.x.http1.headers.upgrade.Upgrade;
import cool.scx.http.x.http1.request_line.RequestTargetForm;
import cool.scx.tcp.ScxTCPSocket;
import cool.scx.websocket.ScxClientWebSocketHandshakeRequest;
import cool.scx.websocket.ScxClientWebSocketHandshakeResponse;
import cool.scx.websocket.x.ClientWebSocketHandshakeResponse;
import cool.scx.websocket.x.WebSocketOptions;
import java.io.IOException;

public class ClientWebSocketHandshakeRequest
implements ScxClientWebSocketHandshakeRequest,
Http1ClientRequest {
    private final HttpClient httpClient;
    private final WebSocketOptions webSocketOptions;
    private ScxURIWritable uri;
    private Http1Headers headers;
    private RequestTargetForm requestTargetForm;

    public ClientWebSocketHandshakeRequest(HttpClient httpClient, WebSocketOptions webSocketOptions) {
        this.httpClient = httpClient;
        this.webSocketOptions = webSocketOptions;
        this.uri = ScxURI.of();
        this.headers = new Http1Headers();
        this.requestTargetForm = RequestTargetForm.ORIGIN_FORM;
    }

    public ScxURIWritable uri() {
        return this.uri;
    }

    public ScxHttpHeadersWritable headers() {
        return this.headers;
    }

    public ScxClientWebSocketHandshakeRequest uri(ScxURI uri) {
        this.uri = ScxURI.of((ScxURI)uri);
        return this;
    }

    public ScxClientWebSocketHandshakeRequest headers(ScxHttpHeaders headers) {
        this.headers = new Http1Headers(headers);
        return this;
    }

    public ScxClientWebSocketHandshakeResponse sendHandshake() {
        ScxTCPSocket tcpSocket;
        try {
            tcpSocket = this.httpClient.createTCPSocket((ScxURI)this.uri, new String[]{HttpVersion.HTTP_1_1.alpnValue()});
        }
        catch (IOException e) {
            throw new HttpSendException("\u521b\u5efa\u8fde\u63a5\u5931\u8d25 !!!", (Throwable)e);
        }
        String secWebsocketKey = Base64Utils.encodeToString((byte[])RandomUtils.randomBytes((int)16));
        this.headers.connection(Connection.UPGRADE);
        this.headers.upgrade((ScxUpgrade)Upgrade.WEB_SOCKET);
        this.headers.set((ScxHttpHeaderName)HttpFieldName.SEC_WEBSOCKET_KEY, new String[]{secWebsocketKey});
        this.headers.set((ScxHttpHeaderName)HttpFieldName.SEC_WEBSOCKET_VERSION, new String[]{"13"});
        if (!tcpSocket.isTLS() && this.httpClient.options().proxy() != null && this.httpClient.options().proxy().enabled()) {
            this.requestTargetForm = RequestTargetForm.ABSOLUTE_FORM;
        }
        Http1ClientConnection connection = new Http1ClientConnection(tcpSocket, this.httpClient.options());
        try {
            ScxHttpClientResponse response = connection.sendRequest((Http1ClientRequest)this, (MediaWriter)EmptyWriter.EMPTY_WRITER).waitResponse();
            return new ClientWebSocketHandshakeResponse(connection, response, this.webSocketOptions);
        }
        catch (IOException e) {
            throw new HttpSendException("\u53d1\u9001 WebSocket \u63e1\u624b\u8bf7\u6c42\u5931\u8d25 !!!", (Throwable)e);
        }
    }

    public RequestTargetForm requestTargetForm() {
        return this.requestTargetForm;
    }

    public Http1ClientRequest requestTargetForm(RequestTargetForm requestTargetForm) {
        this.requestTargetForm = requestTargetForm;
        return this;
    }
}

