/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.websocket.x;

import cool.scx.common.util.RandomUtils;
import cool.scx.io.data_reader.DataReader;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.tcp.ScxTCPSocket;
import cool.scx.websocket.ScxWebSocket;
import cool.scx.websocket.WebSocketFrame;
import cool.scx.websocket.WebSocketHelper;
import cool.scx.websocket.WebSocketOpCode;
import cool.scx.websocket.close_info.ScxWebSocketCloseInfo;
import cool.scx.websocket.close_info.WebSocketCloseInfo;
import cool.scx.websocket.exception.WebSocketException;
import cool.scx.websocket.x.WebSocketOptions;
import cool.scx.websocket.x.WebSocketProtocolFrame;
import cool.scx.websocket.x.WebSocketProtocolFrameHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.locks.ReentrantLock;

public class WebSocket
implements ScxWebSocket {
    private final ScxTCPSocket tcpSocket;
    private final DataReader reader;
    private final OutputStream writer;
    private final WebSocketOptions options;
    private final ReentrantLock lock;
    private final boolean isClient;
    protected boolean closeSent;

    public WebSocket(ScxTCPSocket tcpSocket, DataReader reader, OutputStream writer, WebSocketOptions options, boolean isClient) {
        this.tcpSocket = tcpSocket;
        this.reader = reader;
        this.writer = writer;
        this.options = options;
        this.lock = new ReentrantLock();
        this.isClient = isClient;
    }

    public WebSocketFrame readFrame() {
        try {
            WebSocketProtocolFrame protocolFrame = this.readProtocolFrame();
            if (protocolFrame.opCode() == WebSocketOpCode.CLOSE) {
                this.handleCloseFrame(protocolFrame);
            }
            return WebSocketFrame.of((WebSocketOpCode)protocolFrame.opCode(), (byte[])protocolFrame.payloadData(), (boolean)protocolFrame.fin());
        }
        catch (NoMoreDataException e) {
            throw new WebSocketException(WebSocketCloseInfo.NORMAL_CLOSE.code(), WebSocketCloseInfo.NORMAL_CLOSE.reason());
        }
    }

    public ScxWebSocket sendFrame(WebSocketFrame frame) {
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot send frame: WebSocket is already closed");
        }
        if (this.closeSent) {
            if (frame.opCode() == WebSocketOpCode.CLOSE) {
                return this;
            }
            throw new IllegalStateException("Cannot send non-close frames after a Close frame has been sent");
        }
        WebSocketProtocolFrame protocolFrame = this.createProtocolFrame(frame);
        try {
            this.writeProtocolFrame(protocolFrame);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (frame.opCode() == WebSocketOpCode.CLOSE) {
            this.closeSent = true;
        }
        return this;
    }

    public ScxWebSocket terminate() {
        try {
            this.tcpSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public boolean isClosed() {
        return this.tcpSocket.isClosed();
    }

    private WebSocketProtocolFrame createProtocolFrame(WebSocketFrame frame) {
        if (this.isClient) {
            byte[] maskingKey = RandomUtils.randomBytes((int)4);
            return WebSocketProtocolFrame.of(frame.fin(), frame.opCode(), maskingKey, frame.payloadData());
        }
        return WebSocketProtocolFrame.of(frame.fin(), frame.opCode(), frame.payloadData());
    }

    private void writeProtocolFrame(WebSocketProtocolFrame protocolFrame) throws IOException {
        this.lock.lock();
        try {
            WebSocketProtocolFrameHelper.writeFrame(protocolFrame, this.writer);
        }
        finally {
            this.lock.unlock();
        }
    }

    private WebSocketProtocolFrame readProtocolFrame() {
        if (this.options.mergeWebSocketFrame()) {
            return WebSocketProtocolFrameHelper.readFrameUntilLast(this.reader, this.options.maxWebSocketFrameSize(), this.options.maxWebSocketMessageSize());
        }
        return WebSocketProtocolFrameHelper.readFrame(this.reader, this.options.maxWebSocketFrameSize());
    }

    public void handleCloseFrame(WebSocketProtocolFrame protocolFrame) {
        ScxWebSocketCloseInfo closeInfo = WebSocketHelper.parseCloseInfo((byte[])protocolFrame.payloadData());
        try {
            this.close(closeInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.terminate();
    }
}

