/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.websocket.x;

import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.headers.HttpFieldName;
import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.status.HttpStatus;
import cool.scx.http.status.ScxHttpStatus;
import cool.scx.http.x.http1.Http1ServerConnection;
import cool.scx.http.x.http1.Http1ServerResponse;
import cool.scx.http.x.http1.headers.connection.Connection;
import cool.scx.http.x.http1.headers.upgrade.ScxUpgrade;
import cool.scx.http.x.http1.headers.upgrade.Upgrade;
import cool.scx.websocket.ScxServerWebSocketHandshakeResponse;
import cool.scx.websocket.ScxWebSocket;
import cool.scx.websocket.WebSocketHelper;
import cool.scx.websocket.x.Http1ServerWebSocketHandshakeRequest;
import cool.scx.websocket.x.WebSocket;
import cool.scx.websocket.x.WebSocketOptions;

public class Http1ServerWebSocketHandshakeResponse
implements ScxServerWebSocketHandshakeResponse {
    private final WebSocketOptions webSocketOptions;
    private final Http1ServerWebSocketHandshakeRequest request;
    private final Http1ServerConnection connection;
    private final Http1ServerResponse _response;
    private WebSocket webSocket;

    public Http1ServerWebSocketHandshakeResponse(Http1ServerConnection connection, Http1ServerWebSocketHandshakeRequest request, Http1ServerResponse _response, WebSocketOptions webSocketOptions) {
        this.connection = connection;
        this.request = request;
        this._response = _response;
        this.webSocketOptions = webSocketOptions;
    }

    public ScxWebSocket webSocket() {
        return this.webSocket != null ? this.webSocket : this.acceptHandshake();
    }

    public Http1ServerWebSocketHandshakeRequest request() {
        return this.request;
    }

    public ScxHttpStatus status() {
        return this._response.status();
    }

    public ScxHttpHeadersWritable headers() {
        return this._response.headers();
    }

    public ScxHttpServerResponse status(ScxHttpStatus code) {
        return this._response.status(code);
    }

    public ScxHttpServerResponse headers(ScxHttpHeaders headers) {
        return this._response.headers(headers);
    }

    public Void send(MediaWriter writer) {
        return this._response.send(writer);
    }

    public boolean isSent() {
        return this._response.isSent();
    }

    private ScxWebSocket acceptHandshake() {
        if (this.webSocket == null) {
            this._response.headers().upgrade((ScxUpgrade)Upgrade.WEB_SOCKET);
            this._response.headers().connection(Connection.UPGRADE);
            this._response.headers().set((ScxHttpHeaderName)HttpFieldName.SEC_WEBSOCKET_ACCEPT, new String[]{WebSocketHelper.generateSecWebSocketAccept((String)this.request().secWebSocketKey())});
            this.status((ScxHttpStatus)HttpStatus.SWITCHING_PROTOCOLS).send();
            this.webSocket = new WebSocket(this.connection.tcpSocket, this.connection.dataReader, this.connection.dataWriter, this.webSocketOptions, false);
            this.connection.stop();
        }
        return this.webSocket;
    }
}

