/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.websocket.x;

import cool.scx.websocket.WebSocketOpCode;

public final class WebSocketProtocolFrame {
    private final boolean fin;
    private final boolean rsv1;
    private final boolean rsv2;
    private final boolean rsv3;
    private final WebSocketOpCode opCode;
    private final boolean masked;
    private final int payloadLength;
    private final byte[] maskingKey;
    private byte[] payloadData;

    public WebSocketProtocolFrame(boolean fin, boolean rsv1, boolean rsv2, boolean rsv3, WebSocketOpCode opCode, boolean masked, int payloadLength, byte[] maskingKey, byte[] payloadData) {
        this.fin = fin;
        this.rsv1 = rsv1;
        this.rsv2 = rsv2;
        this.rsv3 = rsv3;
        this.opCode = opCode;
        this.masked = masked;
        this.payloadLength = payloadLength;
        this.maskingKey = maskingKey;
        this.payloadData = payloadData;
    }

    public WebSocketProtocolFrame(boolean fin, boolean rsv1, boolean rsv2, boolean rsv3, WebSocketOpCode opCode, boolean masked, int payloadLength, byte[] maskingKey) {
        this(fin, rsv1, rsv2, rsv3, opCode, masked, payloadLength, maskingKey, null);
    }

    public static WebSocketProtocolFrame of(boolean fin, WebSocketOpCode opCode, byte[] maskingKey, byte[] payloadData) {
        return new WebSocketProtocolFrame(fin, false, false, false, opCode, maskingKey != null, payloadData.length, maskingKey, payloadData);
    }

    public static WebSocketProtocolFrame of(boolean fin, WebSocketOpCode opCode, byte[] payloadData) {
        return WebSocketProtocolFrame.of(fin, opCode, null, payloadData);
    }

    public static WebSocketProtocolFrame of(WebSocketOpCode opCode, byte[] payloadData) {
        return WebSocketProtocolFrame.of(true, opCode, payloadData);
    }

    public boolean fin() {
        return this.fin;
    }

    public boolean rsv1() {
        return this.rsv1;
    }

    public boolean rsv2() {
        return this.rsv2;
    }

    public boolean rsv3() {
        return this.rsv3;
    }

    public WebSocketOpCode opCode() {
        return this.opCode;
    }

    public boolean masked() {
        return this.masked;
    }

    public int payloadLength() {
        return this.payloadLength;
    }

    public byte[] maskingKey() {
        return this.maskingKey;
    }

    public byte[] payloadData() {
        return this.payloadData;
    }

    public WebSocketProtocolFrame payloadData(byte[] payloadData) {
        this.payloadData = payloadData;
        return this;
    }

    public String toString() {
        return "WebSocketFrame[fin=" + this.fin + ", rsv1=" + this.rsv1 + ", rsv2=" + this.rsv2 + ", rsv3=" + this.rsv3 + ", opCode=" + String.valueOf(this.opCode) + ", masked=" + this.masked + ", payloadLength=" + this.payloadLength + ", maskingKey=" + String.valueOf(this.maskingKey) + ", payloadData=" + String.valueOf(this.payloadData) + "]";
    }
}

