/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.websocket.x;

import cool.scx.http.ScxHttpClientResponse;
import cool.scx.http.body.ScxHttpBody;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.status.HttpStatus;
import cool.scx.http.status.ScxHttpStatus;
import cool.scx.http.x.http1.Http1ClientConnection;
import cool.scx.websocket.ScxClientWebSocketHandshakeResponse;
import cool.scx.websocket.ScxWebSocket;
import cool.scx.websocket.x.WebSocket;
import cool.scx.websocket.x.WebSocketOptions;

public class ClientWebSocketHandshakeResponse
implements ScxClientWebSocketHandshakeResponse {
    private final Http1ClientConnection connection;
    private final ScxHttpClientResponse response;
    private final WebSocketOptions webSocketOptions;
    private ScxWebSocket webSocket;

    public ClientWebSocketHandshakeResponse(Http1ClientConnection connection, ScxHttpClientResponse response, WebSocketOptions webSocketOptions) {
        this.connection = connection;
        this.response = response;
        this.webSocketOptions = webSocketOptions;
    }

    public boolean handshakeSucceeded() {
        return HttpStatus.SWITCHING_PROTOCOLS.equals((Object)this.response.status());
    }

    public ScxWebSocket webSocket() {
        if (this.webSocket == null) {
            if (!this.handshakeSucceeded()) {
                throw new RuntimeException("Unexpected response status: " + String.valueOf(this.response.status()));
            }
            this.webSocket = new WebSocket(this.connection.tcpSocket, this.connection.dataReader, this.connection.tcpSocket.outputStream(), this.webSocketOptions, true);
        }
        return this.webSocket;
    }

    public ScxHttpStatus status() {
        return this.response.status();
    }

    public ScxHttpHeaders headers() {
        return this.response.headers();
    }

    public ScxHttpBody body() {
        return this.response.body();
    }
}

