/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.websocket.event;

import cool.scx.websocket.ScxWebSocket;
import cool.scx.websocket.WebSocketFrame;
import cool.scx.websocket.close_info.ScxWebSocketCloseInfo;
import cool.scx.websocket.close_info.WebSocketCloseInfo;
import cool.scx.websocket.event.BinaryMessageHandler;
import cool.scx.websocket.event.CloseHandler;
import cool.scx.websocket.event.ScxEventWebSocket;
import cool.scx.websocket.event.TextMessageHandler;
import cool.scx.websocket.exception.WebSocketException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

class ScxEventWebSocketImpl
implements ScxEventWebSocket {
    private static final System.Logger LOGGER = System.getLogger(ScxEventWebSocketImpl.class.getName());
    private final ScxWebSocket ws;
    private final Executor callbackExecutor;
    protected ContinuationType continuationType;
    private TextMessageHandler textMessageHandler;
    private BinaryMessageHandler binaryMessageHandler;
    private Consumer<byte[]> pingHandler;
    private Consumer<byte[]> pongHandler;
    private CloseHandler closeHandler;
    private Consumer<Throwable> errorHandler;
    private boolean running;

    public ScxEventWebSocketImpl(ScxWebSocket websocket) {
        this(websocket, null);
    }

    public ScxEventWebSocketImpl(ScxWebSocket websocket, Executor callbackExecutor) {
        this.ws = websocket;
        this.callbackExecutor = callbackExecutor;
        this.textMessageHandler = null;
        this.binaryMessageHandler = null;
        this.pingHandler = null;
        this.pongHandler = null;
        this.closeHandler = null;
        this.errorHandler = null;
        this.running = false;
    }

    @Override
    public WebSocketFrame readFrame() {
        return this.ws.readFrame();
    }

    @Override
    public ScxWebSocket sendFrame(WebSocketFrame frame) {
        return this.ws.sendFrame(frame);
    }

    @Override
    public ScxWebSocket terminate() {
        return this.ws.terminate();
    }

    @Override
    public boolean isClosed() {
        return this.ws.isClosed();
    }

    @Override
    public ScxEventWebSocket onTextMessage(TextMessageHandler textMessageHandler) {
        this.textMessageHandler = textMessageHandler;
        return this;
    }

    @Override
    public ScxEventWebSocket onBinaryMessage(BinaryMessageHandler binaryMessageHandler) {
        this.binaryMessageHandler = binaryMessageHandler;
        return this;
    }

    @Override
    public ScxEventWebSocket onPing(Consumer<byte[]> pingHandler) {
        this.pingHandler = pingHandler;
        return this;
    }

    @Override
    public ScxEventWebSocket onPong(Consumer<byte[]> pongHandler) {
        this.pongHandler = pongHandler;
        return this;
    }

    @Override
    public ScxEventWebSocket onClose(CloseHandler closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    @Override
    public ScxEventWebSocket onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    @Override
    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        while (this.running) {
            try {
                WebSocketFrame frame = this.readFrame();
                this.handleFrame(frame);
            }
            catch (WebSocketException e) {
                this._handleCloseByException(WebSocketCloseInfo.NORMAL_CLOSE.code(), WebSocketCloseInfo.NORMAL_CLOSE.reason(), e.closeCode(), e.getMessage());
            }
            catch (Exception e) {
                this._handleError(e);
                this._handleCloseByException(WebSocketCloseInfo.CLOSED_ABNORMALLY.code(), WebSocketCloseInfo.CLOSED_ABNORMALLY.reason(), WebSocketCloseInfo.UNEXPECTED_CONDITION.code(), e.getMessage());
            }
        }
    }

    @Override
    public void stop() {
        this.running = false;
    }

    private void handleFrame(WebSocketFrame frame) {
        switch (frame.opCode()) {
            case CONTINUATION: {
                this._handleContinuation(frame);
                break;
            }
            case TEXT: {
                this._handleText(frame);
                break;
            }
            case BINARY: {
                this._handleBinary(frame);
                break;
            }
            case PING: {
                this._handlePing(frame);
                break;
            }
            case PONG: {
                this._handlePong(frame);
                break;
            }
            case CLOSE: {
                this._handleClose(frame);
            }
        }
    }

    private void _handleContinuation(WebSocketFrame frame) {
        boolean finalFrame = frame.fin();
        ContinuationType ct = this.continuationType;
        if (finalFrame) {
            this.continuationType = ContinuationType.NONE;
        }
        switch (ct.ordinal()) {
            case 1: {
                try {
                    this._callOnTextMessage(new String(frame.payloadData()), finalFrame);
                }
                catch (Exception e) {
                    LOGGER.log(System.Logger.Level.ERROR, "Error while calling onTextMessage", (Throwable)e);
                }
                break;
            }
            case 2: {
                try {
                    this._callOnBinaryMessage(frame.payloadData(), finalFrame);
                }
                catch (Exception e) {
                    LOGGER.log(System.Logger.Level.ERROR, "Error while calling onBinaryMessage", (Throwable)e);
                }
                break;
            }
            default: {
                throw new WebSocketException(WebSocketCloseInfo.PROTOCOL_ERROR.code(), "Unexpected continuation received");
            }
        }
    }

    private void _handleText(WebSocketFrame frame) {
        this.continuationType = ContinuationType.TEXT;
        try {
            this._callOnTextMessage(new String(frame.payloadData()), frame.fin());
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.ERROR, "Error while calling onTextMessage : ", (Throwable)e);
        }
    }

    private void _handleBinary(WebSocketFrame frame) {
        this.continuationType = ContinuationType.BINARY;
        try {
            this._callOnBinaryMessage(frame.payloadData(), frame.fin());
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.ERROR, "Error while call onBinaryMessage : ", (Throwable)e);
        }
    }

    private void _handlePing(WebSocketFrame frame) {
        try {
            this._callOnPing(frame.payloadData());
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.ERROR, "Error while call onPing : ", (Throwable)e);
        }
    }

    private void _handlePong(WebSocketFrame frame) {
        try {
            this._callOnPong(frame.payloadData());
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.ERROR, "Error while call onPong : ", (Throwable)e);
        }
    }

    private void _handleClose(WebSocketFrame frame) {
        ScxWebSocketCloseInfo closeInfo = frame.getCloseInfo();
        this._handleCloseByFrame(closeInfo.code(), closeInfo.reason(), WebSocketCloseInfo.NORMAL_CLOSE.code(), WebSocketCloseInfo.NORMAL_CLOSE.reason());
    }

    public void _handleCloseByFrame(int code, String reason, int peerCode, String peerReason) {
        try {
            this._callOnClose(code, reason);
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.ERROR, "Error while call onClose : ", (Throwable)e);
        }
        this.stop();
    }

    public void _handleCloseByException(int code, String reason, int peerCode, String peerReason) {
        try {
            this._callOnClose(code, reason);
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.ERROR, "Error while call onClose : ", (Throwable)e);
        }
        try {
            this.close(peerCode, peerReason);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ws.terminate();
        this.stop();
    }

    private void _handleError(Exception e) {
        try {
            this._callOnError(e);
        }
        catch (Exception ex) {
            LOGGER.log(System.Logger.Level.ERROR, "Error while call onError : ", (Throwable)ex);
        }
    }

    private void _callOnTextMessage(String text, boolean last) {
        if (this.textMessageHandler == null) {
            return;
        }
        if (this.callbackExecutor == null) {
            this.textMessageHandler.handle(text, last);
        } else {
            this.callbackExecutor.execute(() -> this.textMessageHandler.handle(text, last));
        }
    }

    private void _callOnBinaryMessage(byte[] binary, boolean last) {
        if (this.binaryMessageHandler == null) {
            return;
        }
        if (this.callbackExecutor == null) {
            this.binaryMessageHandler.handle(binary, last);
        } else {
            this.callbackExecutor.execute(() -> this.binaryMessageHandler.handle(binary, last));
        }
    }

    private void _callOnPing(byte[] bytes) {
        if (this.pingHandler == null) {
            return;
        }
        if (this.callbackExecutor == null) {
            this.pingHandler.accept(bytes);
        } else {
            this.callbackExecutor.execute(() -> this.pingHandler.accept(bytes));
        }
    }

    private void _callOnPong(byte[] bytes) {
        if (this.pongHandler == null) {
            return;
        }
        if (this.callbackExecutor == null) {
            this.pongHandler.accept(bytes);
        } else {
            this.callbackExecutor.execute(() -> this.pongHandler.accept(bytes));
        }
    }

    private void _callOnClose(int code, String reason) {
        if (this.closeHandler == null) {
            return;
        }
        if (this.callbackExecutor == null) {
            this.closeHandler.handle(code, reason);
        } else {
            this.callbackExecutor.execute(() -> this.closeHandler.handle(code, reason));
        }
    }

    private void _callOnError(Exception e) {
        if (this.errorHandler == null) {
            return;
        }
        if (this.callbackExecutor == null) {
            this.errorHandler.accept(e);
        } else {
            this.callbackExecutor.execute(() -> this.errorHandler.accept(e));
        }
    }

    public static enum ContinuationType {
        NONE,
        TEXT,
        BINARY;

    }
}

