/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.websocket;

import cool.scx.websocket.WebSocketFrame;
import cool.scx.websocket.WebSocketHelper;
import cool.scx.websocket.WebSocketOpCode;
import cool.scx.websocket.close_info.ScxWebSocketCloseInfo;
import cool.scx.websocket.close_info.WebSocketCloseInfo;
import cool.scx.websocket.exception.WebSocketException;

public interface ScxWebSocket {
    public WebSocketFrame readFrame() throws WebSocketException;

    public ScxWebSocket sendFrame(WebSocketFrame var1);

    public ScxWebSocket terminate();

    public boolean isClosed();

    default public ScxWebSocket send(String textMessage, boolean last) {
        byte[] payload = textMessage != null ? textMessage.getBytes() : new byte[]{};
        WebSocketFrame frame = WebSocketFrame.of(WebSocketOpCode.TEXT, payload, last);
        this.sendFrame(frame);
        return this;
    }

    default public ScxWebSocket send(byte[] binaryMessage, boolean last) {
        WebSocketFrame frame = WebSocketFrame.of(WebSocketOpCode.BINARY, binaryMessage, last);
        this.sendFrame(frame);
        return this;
    }

    default public ScxWebSocket ping(byte[] data) {
        WebSocketFrame frame = WebSocketFrame.of(WebSocketOpCode.PING, data);
        this.sendFrame(frame);
        return this;
    }

    default public ScxWebSocket pong(byte[] data) {
        WebSocketFrame frame = WebSocketFrame.of(WebSocketOpCode.PONG, data);
        this.sendFrame(frame);
        return this;
    }

    default public ScxWebSocket close(int code, String reason) {
        byte[] closePayload = WebSocketHelper.createClosePayload(code, reason);
        WebSocketFrame frame = WebSocketFrame.of(WebSocketOpCode.CLOSE, closePayload);
        this.sendFrame(frame);
        return this;
    }

    default public ScxWebSocket send(String textMessage) {
        return this.send(textMessage, true);
    }

    default public ScxWebSocket send(byte[] binaryMessage) {
        return this.send(binaryMessage, true);
    }

    default public ScxWebSocket close(ScxWebSocketCloseInfo closeInfo) {
        return this.close(closeInfo.code(), closeInfo.reason());
    }

    default public ScxWebSocket close() {
        return this.close(WebSocketCloseInfo.NORMAL_CLOSE);
    }
}

