/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.websocket;

import cool.scx.common.util.HashUtils;
import cool.scx.websocket.close_info.ScxWebSocketCloseInfo;
import java.util.Base64;

public class WebSocketHelper {
    public static String generateSecWebSocketAccept(String key) {
        return Base64.getEncoder().encodeToString(HashUtils.sha1((String)(key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11")));
    }

    public static ScxWebSocketCloseInfo parseCloseInfo(byte[] frame) {
        int len = frame.length;
        int code = 1005;
        if (len >= 2) {
            code = (frame[0] & 0xFF) << 8 | frame[1] & 0xFF;
        }
        String reason = null;
        if (len > 2) {
            reason = new String(frame, 2, len - 2);
        }
        return ScxWebSocketCloseInfo.of(code, reason);
    }

    public static byte[] createClosePayload(int code, String reason) {
        byte[] reasonBytes = reason != null ? reason.getBytes() : new byte[]{};
        byte[] payload = new byte[2 + reasonBytes.length];
        payload[0] = (byte)(code >> 8);
        payload[1] = (byte)(code & 0xFF);
        System.arraycopy(reasonBytes, 0, payload, 2, reasonBytes.length);
        return payload;
    }
}

