/*
 * Decompiled with CFR 0.152.
 */
package com.s24.search.solr.analyzers;

import com.s24.search.solr.analyzers.StemmingBufferAttribute;
import java.util.Arrays;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class StemmingBufferAttributeImpl
extends AttributeImpl
implements StemmingBufferAttribute {
    char[] stemmedToken = new char[16];
    int stemmedTokenLength = 0;
    char[] originalToken = new char[16];
    int originalTokenLength = 0;
    private boolean stemmedTokenHasBeenEmitted = false;

    @Override
    public void clear() {
        this.stemmedTokenLength = 0;
        this.originalTokenLength = 0;
        this.setStemmedTokenHasBeenEmitted(false);
    }

    public void copyTo(AttributeImpl input) {
        StemmingBufferAttributeImpl copyAttributeImpl = (StemmingBufferAttributeImpl)input;
        if (copyAttributeImpl.stemmedToken.length < this.stemmedTokenLength) {
            copyAttributeImpl.stemmedToken = new char[this.stemmedTokenLength];
        }
        System.arraycopy(this.stemmedToken, 0, copyAttributeImpl.stemmedToken, 0, this.stemmedTokenLength);
        if (copyAttributeImpl.originalToken.length < this.originalTokenLength) {
            copyAttributeImpl.originalToken = new char[this.originalTokenLength];
        }
        System.arraycopy(this.originalToken, 0, copyAttributeImpl.originalToken, 0, this.originalTokenLength);
        copyAttributeImpl.stemmedTokenLength = this.stemmedTokenLength;
        copyAttributeImpl.originalTokenLength = this.originalTokenLength;
        copyAttributeImpl.stemmedTokenHasBeenEmitted = this.stemmedTokenHasBeenEmitted;
    }

    @Override
    public void setOriginalToken(char[] buffer, int length) {
        this.originalToken = this.assureArrayLenth(this.originalToken, length);
        System.arraycopy(buffer, 0, this.originalToken, 0, length);
        this.originalTokenLength = length;
    }

    @Override
    public void setStemmedToken(char[] buffer, int length) {
        this.stemmedToken = this.assureArrayLenth(this.stemmedToken, length);
        System.arraycopy(buffer, 0, this.stemmedToken, 0, length);
        this.stemmedTokenLength = length;
    }

    @Override
    public char[] getOriginalToken() {
        return this.originalToken;
    }

    @Override
    public int getOriginalTokenLength() {
        return this.originalTokenLength;
    }

    @Override
    public char[] getStemmedToken() {
        return this.stemmedToken;
    }

    @Override
    public int getStemmedTokenLength() {
        return this.stemmedTokenLength;
    }

    @Override
    public boolean isStemmedTokenHasBeenEmitted() {
        return this.stemmedTokenHasBeenEmitted;
    }

    @Override
    public void setStemmedTokenHasBeenEmitted(boolean stemmedTokenHasBeenEmitted) {
        this.stemmedTokenHasBeenEmitted = stemmedTokenHasBeenEmitted;
    }

    protected char[] assureArrayLenth(char[] array, int length) {
        if (array.length < length) {
            char[] newArray = new char[length];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public String toString() {
        return "StemmingBufferAttributeImpl [stemmedToken=" + Arrays.toString(this.stemmedToken) + ", stemmedTokenLength=" + this.stemmedTokenLength + ", originalToken=" + Arrays.toString(this.originalToken) + ", originalTokenLength=" + this.originalTokenLength + "]";
    }

    public void reflectWith(AttributeReflector reflector) {
        reflector.reflect(StemmingBufferAttribute.class, "stemmedToken", (Object)this.stemmedToken);
        reflector.reflect(StemmingBufferAttribute.class, "stemmedTokenLength", (Object)this.stemmedTokenLength);
        reflector.reflect(StemmingBufferAttribute.class, "originalToken", (Object)this.originalToken);
        reflector.reflect(StemmingBufferAttribute.class, "originalTokenLength", (Object)this.originalTokenLength);
    }
}

