/*
 * Decompiled with CFR 0.152.
 */
package cool.solr.response;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.solr.core.SolrResourceLoader;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public class LuceneTemplateResource
implements ITemplateResource {
    private final SolrResourceLoader resourceLoader;
    private final String path;
    private final String characterEncoding;

    public LuceneTemplateResource(SolrResourceLoader resourceLoader, String path, String characterEncoding) {
        this.resourceLoader = resourceLoader;
        this.path = path;
        this.characterEncoding = characterEncoding;
    }

    public String getDescription() {
        return this.path;
    }

    public String getBaseName() {
        if (StringUtils.isEmptyOrWhitespace((String)this.path)) {
            return null;
        }
        String basePath = this.path.charAt(this.path.length() - 1) == '/' ? this.path.substring(0, this.path.length() - 1) : this.path;
        int slashPos = basePath.lastIndexOf(47);
        int dotPos = basePath.lastIndexOf(46);
        if (slashPos == -1) {
            if (dotPos != -1) {
                return basePath.substring(0, dotPos);
            }
        } else {
            if (dotPos != -1 && dotPos > slashPos + 1) {
                return basePath.substring(slashPos + 1, dotPos);
            }
            return basePath.substring(slashPos + 1);
        }
        return basePath.isEmpty() ? null : basePath;
    }

    public boolean exists() {
        try {
            this.resourceLoader.openResource(this.path);
            return true;
        }
        catch (IOException exception) {
            return false;
        }
    }

    public Reader reader() throws IOException {
        InputStream inputStream = this.resourceLoader.openResource(this.path);
        if (!StringUtils.isEmptyOrWhitespace((String)this.characterEncoding)) {
            return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream), this.characterEncoding));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream), StandardCharsets.UTF_8));
    }

    public ITemplateResource relative(String relativeLocation) {
        String fullRelativeLocation;
        Validate.notEmpty((String)relativeLocation, (String)"Relative Path cannot be null or empty");
        int separatorPos = this.path.lastIndexOf(47);
        if (separatorPos == -1) {
            fullRelativeLocation = relativeLocation;
        } else {
            StringBuilder relativeBuilder = new StringBuilder(this.path.length() + relativeLocation.length());
            relativeBuilder.append(this.path, 0, separatorPos);
            if (relativeLocation.charAt(0) != '/') {
                relativeBuilder.append('/');
            }
            relativeBuilder.append(relativeLocation);
            fullRelativeLocation = relativeBuilder.toString();
        }
        return new LuceneTemplateResource(this.resourceLoader, fullRelativeLocation, this.characterEncoding);
    }
}

