/*
 * Decompiled with CFR 0.152.
 */
package cool.solr.response;

import com.google.common.base.Preconditions;
import cool.solr.response.FakeServletResponse;
import cool.solr.response.LuceneTemplateResolver;
import cool.solr.response.NamedListPropertyAccessor;
import java.io.Writer;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafResponseWriter
implements QueryResponseWriter,
SolrCoreAware {
    private TemplateEngine templateEngine;
    private LuceneTemplateResolver templateResolver;
    private LayoutDialect layoutDialect;
    private Locale locale = Locale.getDefault();
    private SolrParams configuration;

    public void inform(SolrCore core) {
        this.templateResolver.setResourceLoader(core.getResourceLoader());
        this.getEngine().clearTemplateCache();
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) {
        Preconditions.checkNotNull((Object)writer);
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)response);
        String templateName = request.getParams().get("tl.template");
        Preconditions.checkNotNull((Object)templateName, (Object)"No tl.template given");
        if (request.getParams().getBool("tl.clearCache", false)) {
            this.getEngine().clearTemplateCache();
        }
        HttpServletRequest httpServletRequest = null;
        if (request.getHttpSolrCall().getReq() != null) {
            httpServletRequest = request.getHttpSolrCall().getReq();
        } else if (request.getContext().containsKey("httpRequest")) {
            httpServletRequest = (HttpServletRequest)request.getContext().get("httpRequest");
        }
        WebContext context = new WebContext(httpServletRequest, (HttpServletResponse)new FakeServletResponse(), httpServletRequest.getServletContext(), this.locale);
        context.setVariable("request", (Object)request);
        context.setVariable("params", (Object)request.getParams().toNamedList().asShallowMap());
        QueryResponse rsp = new QueryResponse();
        NamedList parsedResponse = BinaryResponseWriter.getParsedResponse((SolrQueryRequest)request, (SolrQueryResponse)response);
        rsp.setResponse(parsedResponse);
        context.setVariable("response", (Object)rsp);
        this.preProcess(context, request, response);
        this.getEngine().process(templateName, (IContext)context, writer);
    }

    protected void preProcess(WebContext context, SolrQueryRequest request, SolrQueryResponse response) {
    }

    protected TemplateEngine getEngine() {
        if (this.templateEngine == null) {
            this.templateResolver.setPrefix(this.configuration.get("tl.prefix", "templates/"));
            TemplateEngine te = new TemplateEngine();
            te.setTemplateResolver((ITemplateResolver)this.templateResolver);
            te.addDialect((IDialect)this.layoutDialect);
            this.templateEngine = te;
        }
        return this.templateEngine;
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        Preconditions.checkNotNull((Object)request);
        return request.getParams().get("tl.contentType", "text/html;charset=UTF-8");
    }

    public void init(NamedList args) {
        Preconditions.checkNotNull((Object)args);
        this.configuration = args.toSolrParams();
        this.templateResolver = new LuceneTemplateResolver();
        this.templateResolver.setCharacterEncoding("utf-8");
        this.templateResolver.setTemplateMode(this.configuration.get("tl.templateMode", "HTML"));
        this.templateResolver.setSuffix(this.configuration.get("tl.suffix", ".html"));
        if (this.configuration.get("tl.cacheTtlMs") != null) {
            this.templateResolver.setCacheTTLMs(Long.parseLong(this.configuration.get("tl.cacheTTLMs")));
        } else {
            this.templateResolver.setCacheTTLMs(TimeUnit.HOURS.toMillis(1L));
        }
        if (this.configuration.get("tl.locale") != null) {
            this.locale = Locale.forLanguageTag(this.configuration.get("tl.locale"));
        }
        this.layoutDialect = new LayoutDialect();
    }

    static {
        try {
            OgnlRuntime.setPropertyAccessor(NamedList.class, (PropertyAccessor)new NamedListPropertyAccessor());
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Exception while configuring OGNL named list property accessor", (Throwable)e);
        }
    }
}

