/*
 * Decompiled with CFR 0.152.
 */
package cool.solr.search.component.solr.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import cool.solr.search.component.solr.query.SearcherAwareLocalSolrQueryRequest;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.QueryComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class SolrLocalResponseBuilder
implements Closeable {
    private final ResponseBuilder origin;
    private final List<SearchComponent> components = new ArrayList<SearchComponent>();
    private SolrParams params;
    private SearcherAwareLocalSolrQueryRequest request;

    public SolrLocalResponseBuilder(ResponseBuilder origin) {
        this.origin = (ResponseBuilder)Preconditions.checkNotNull((Object)origin);
        this.components.add((SearchComponent)SolrLocalResponseBuilder.extractQueryComponent(origin.components));
    }

    @Override
    public void close() {
        if (this.request != null) {
            this.request.close();
        }
        this.components.clear();
    }

    public SolrLocalResponseBuilder useUnscoredSolrParams() {
        this.params = SolrLocalResponseBuilder.computeUnscoredSolrParams(this.origin.req.getParams());
        return this;
    }

    public SolrLocalResponseBuilder useParams(SolrParams params) {
        this.params = params;
        return this;
    }

    public SolrLocalResponseBuilder useFacetComponent() {
        this.components.add((SearchComponent)SolrLocalResponseBuilder.extractFacetComponent(this.origin.components));
        return this;
    }

    public ResponseBuilder build() {
        Preconditions.checkNotNull((Object)this.params, (Object)"Pre-condition violated: params must not be null.");
        Preconditions.checkArgument((!this.components.isEmpty() ? 1 : 0) != 0, (Object)"Pre-condition violated: expression !components.isEmpty() must be true.");
        this.request = new SearcherAwareLocalSolrQueryRequest(this.origin.req.getSearcher(), this.params);
        SolrQueryResponse checkResponse = new SolrQueryResponse();
        SolrCore.preDecorateResponse((SolrQueryRequest)this.request, (SolrQueryResponse)checkResponse);
        ResponseBuilder response = new ResponseBuilder((SolrQueryRequest)this.request, checkResponse, this.components);
        response.doExpand = false;
        response.doHighlights = false;
        response.doStats = false;
        response.doTerms = false;
        return response;
    }

    public static void execute(ResponseBuilder response) throws IOException {
        for (SearchComponent component : response.components) {
            component.prepare(response);
        }
        for (SearchComponent component : response.components) {
            component.process(response);
        }
    }

    public static ModifiableSolrParams computeUnscoredSolrQueryParams(SolrParams original) {
        Preconditions.checkNotNull((Object)original, (Object)"Pre-condition violated: original must not be null.");
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("q", new String[]{original.get("q")});
        params.set("qf", new String[]{original.get("qf")});
        params.set("defType", new String[]{original.get("defType")});
        params.set("mm", new String[]{original.get("mm")});
        if (original.getParams("fq") != null) {
            for (String fq : original.getParams("fq")) {
                params.add("fq", new String[]{fq});
            }
        }
        params.set("rows", 0);
        params.set("sort", new String[]{"_docid_ asc"});
        params.set("fl", new String[]{"_docid_"});
        return params;
    }

    public static ModifiableSolrParams computeUnscoredSolrParams(SolrParams origParams) {
        Preconditions.checkNotNull((Object)origParams, (Object)"Pre-condition violated: origParams must not be null.");
        ModifiableSolrParams params = new ModifiableSolrParams(origParams);
        params.remove("start");
        params.set("fl", new String[]{"id"});
        params.set("rows", new String[]{"0"});
        params.remove("debug");
        params.remove("echoParams");
        params.remove("group");
        params.remove("bf");
        params.remove("bq");
        params.remove("boost");
        params.remove("rq");
        params.remove("rrq");
        params.remove("pf");
        params.remove("pf2");
        params.remove("pf3");
        params.remove("ps");
        params.remove("ps2");
        params.remove("ps3");
        params.set("enableElevation", new String[]{"false"});
        params.set("forceElevation", new String[]{"false"});
        params.set("spellcheck", new String[]{"false"});
        params.set("facet", new String[]{"false"});
        params.set("collapse", new String[]{"false"});
        params.set("collapse.enable", new String[]{"false"});
        params.set("expand", new String[]{"false"});
        params.set("expand.append", new String[]{"false"});
        params.set("ranking.barkeeper", new String[]{"false"});
        params.set("facet.cache.static", new String[]{"false"});
        params.set("boost.cache", new String[]{"false"});
        params.set("bq.cache", new String[]{"false"});
        params.remove("sort");
        params.set("sort", new String[]{"_docid_ asc"});
        HashSet waste = Sets.newHashSet((Iterable)params.getParameterNames());
        for (String param : waste) {
            if (param.startsWith("spellcheck.")) {
                params.remove(param);
                continue;
            }
            if (param.startsWith("bmax.")) {
                params.remove(param);
                continue;
            }
            if (!param.startsWith("boost.")) continue;
            params.remove(param);
        }
        return params;
    }

    public static QueryComponent extractQueryComponent(List<SearchComponent> components) {
        QueryComponent queryComponent = null;
        if (components != null) {
            for (SearchComponent sc : components) {
                if (!(sc instanceof QueryComponent)) continue;
                queryComponent = (QueryComponent)sc;
                break;
            }
        }
        return queryComponent;
    }

    public static FacetComponent extractFacetComponent(List<SearchComponent> components) {
        FacetComponent facetComponent = null;
        if (components != null) {
            for (SearchComponent sc : components) {
                if (!(sc instanceof FacetComponent)) continue;
                facetComponent = (FacetComponent)sc;
                break;
            }
        }
        return facetComponent;
    }
}

