/*
 * Decompiled with CFR 0.152.
 */
package cool.solr.search.solr.util.analyzing;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import cool.solr.search.solr.util.analyzing.Position;
import java.util.StringJoiner;

public class Token {
    private final String name;
    private final String type;
    private final Position position;
    private final Integer tokenCount;

    public Token(String name, Position positionInOriginal, Integer tokenCount) {
        this(name, null, positionInOriginal, tokenCount);
    }

    public Token(String name, String type, Position positionInOriginal, Integer tokenCount) {
        Preconditions.checkNotNull((Object)name, (Object)"Pre-condition violated: name must not be null.");
        Preconditions.checkNotNull((Object)positionInOriginal, (Object)"Pre-condition violated: positionInOriginal must not be null.");
        Preconditions.checkNotNull((Object)tokenCount, (Object)"Pre-condition violated: tokenCount must not be null.");
        this.type = type;
        this.position = positionInOriginal;
        this.tokenCount = tokenCount;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Position getPosition() {
        return this.position;
    }

    public Integer getTokenCount() {
        return this.tokenCount;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return new StringJoiner(", ", Token.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("type='" + this.type + "'").add("position=" + this.position).add("tokenCount=" + this.tokenCount).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.position, this.tokenCount, this.type});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Token) {
            Token other = (Token)obj;
            return Objects.equal((Object)other.getName(), (Object)this.getName()) && Objects.equal((Object)other.getPosition(), (Object)this.getPosition()) && Objects.equal((Object)other.getType(), (Object)this.getType());
        }
        return false;
    }
}

