/*
 * Decompiled with CFR 0.152.
 */
package cool.solr.search.solr.util;

import cool.solr.search.solr.util.NamedListEntryClassCastException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.NamedList;

public final class NamedLists {
    private NamedLists() {
    }

    public static NamedList<?> navigate(NamedList<?> namedList, String name) {
        return NamedLists.get(namedList, NamedList.class, name);
    }

    public static NamedList<?> navigate(NamedList<?> namedList, String ... names) {
        return NamedLists.get(namedList, NamedList.class, names);
    }

    public static NamedList<?> navigate(NamedList<?> namedList, int index) {
        try {
            return NamedLists.get(namedList, NamedList.class, index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static Set<String> keys(NamedList<?> namedList) {
        if (namedList == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry entry : namedList) {
            result.add((String)entry.getKey());
        }
        return result;
    }

    public static <T> Set<T> getSet(NamedList<?> namedList, String name) {
        return NamedLists.get(namedList, Set.class, name);
    }

    public static <T> Set<T> getSet(NamedList<?> namedList, String ... names) {
        return NamedLists.get(namedList, Set.class, names);
    }

    public static <T> List<T> getList(NamedList<?> namedList, String name) {
        return NamedLists.get(namedList, List.class, name);
    }

    public static <T> List<T> getList(NamedList<?> namedList, String ... names) {
        return NamedLists.get(namedList, List.class, names);
    }

    public static <T> Collection<T> getCollection(NamedList<?> namedList, String name) {
        return NamedLists.get(namedList, Collection.class, name);
    }

    public static <T> Collection<T> getCollection(NamedList<?> namedList, String ... names) {
        return NamedLists.get(namedList, Collection.class, names);
    }

    public static String getString(NamedList<?> namedList, String name) {
        return NamedLists.get(namedList, String.class, name);
    }

    public static String getString(NamedList<?> namedList, String ... names) {
        return NamedLists.get(namedList, String.class, names);
    }

    public static <T> T get(NamedList<?> namedList, Class<T> elementClass, String name) {
        Object value = namedList != null ? namedList.get(name) : null;
        try {
            return elementClass.cast(value);
        }
        catch (ClassCastException e) {
            throw new NamedListEntryClassCastException(name, value.getClass(), elementClass);
        }
    }

    public static <T> T get(NamedList<?> namedList, Class<T> elementClass, String ... names) {
        Object value = namedList != null ? namedList.findRecursive(names) : null;
        try {
            return elementClass.cast(value);
        }
        catch (ClassCastException e) {
            throw new NamedListEntryClassCastException(names, value.getClass(), elementClass);
        }
    }

    public static <T> T get(NamedList<?> namedList, Class<T> elementClass, int index) {
        Object value = namedList != null ? namedList.getVal(index) : null;
        try {
            return elementClass.cast(value);
        }
        catch (ClassCastException e) {
            throw new NamedListEntryClassCastException(index, value.getClass(), elementClass);
        }
    }
}

