/*
 * Decompiled with CFR 0.152.
 */
package cool.solr.search.solr.util.analyzing;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cool.solr.search.solr.util.analyzing.Position;
import cool.solr.search.solr.util.analyzing.Token;
import cool.solr.search.solr.util.analyzing.TokenStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class Analyzers {
    private Analyzers() {
    }

    public static String analyze(Analyzer analyzer, String input, String separator) throws IOException {
        Preconditions.checkNotNull((Object)separator);
        return Joiner.on((String)separator).skipNulls().join(Analyzers.analyze(analyzer, input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> analyze(Analyzer analyzer, String input) throws IOException {
        Preconditions.checkNotNull((Object)analyzer);
        Preconditions.checkNotNull((Object)input);
        ArrayList result = Lists.newArrayList();
        StringReader reader = new StringReader(input);
        TokenStream tokenStream = analyzer.tokenStream("analyzer", (Reader)reader);
        try {
            tokenStream.reset();
            CharTermAttribute charAttr = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            while (tokenStream.incrementToken()) {
                String value = Strings.trimToNull((String)charAttr.toString());
                if (value == null) continue;
                result.add(value);
            }
        }
        finally {
            TokenStreams.endQuietly(tokenStream);
            TokenStreams.closeQuietly((Closeable)tokenStream);
            TokenStreams.closeQuietly(reader);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Token> analyzeTokens(Analyzer analyzer, String input) throws IOException {
        Preconditions.checkNotNull((Object)analyzer);
        Preconditions.checkNotNull((Object)input);
        ArrayList result = Lists.newArrayList();
        StringReader reader = new StringReader(input);
        TokenStream tokenStream = analyzer.tokenStream("analyzer", (Reader)reader);
        try {
            tokenStream.reset();
            int wordPosition = 0;
            CharTermAttribute charAttr = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAttribute = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
            PositionLengthAttribute positionLength = (PositionLengthAttribute)tokenStream.addAttribute(PositionLengthAttribute.class);
            PositionIncrementAttribute positionIncrementAttribute = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
            TypeAttribute typeAttribute = (TypeAttribute)tokenStream.addAttribute(TypeAttribute.class);
            while (tokenStream.incrementToken()) {
                result.add(new Token(charAttr.toString(), typeAttribute.type(), new Position(offsetAttribute.startOffset(), offsetAttribute.endOffset(), (wordPosition += positionIncrementAttribute.getPositionIncrement()) - 1), positionLength.getPositionLength()));
            }
        }
        finally {
            TokenStreams.endQuietly(tokenStream);
            TokenStreams.closeQuietly((Closeable)tokenStream);
            TokenStreams.closeQuietly(reader);
        }
        return result;
    }
}

