/**
 * Copyright (c) 2021 murenchao
 * fig is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.antlr4.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class ReflectUtils {
  public static Field[] getReflectFields(final Class<?> zlass) {
    return zlass.getDeclaredFields();
  }
  
  public static void setReflectFields(final Class<?> zlass, final String name, final Object instance, final Object value) {
    try {
      Field field = zlass.getDeclaredField(name);
      field.setAccessible(true);
      field.set(instance, value);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static Method getMethod(final Class<?> zlass, final String name, final Class<?>... parameterTypes) {
    try {
      Method method = zlass.getMethod(name, parameterTypes);
      method.setAccessible(true);
      return method;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static Field getReflectField(final Class<?> zlass, final String name) {
    try {
      Field field = zlass.getDeclaredField(name);
      field.setAccessible(true);
      return field;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static Object newInstance(final Class<?> zlass, final Object... args) {
    return ReflectUtils.newInstance(zlass, null, args);
  }
  
  public static Object newInstance(final Class<?> zlass, final Class<?>[] parameterTypes, final Object... args) {
    try {
      if ((parameterTypes == null)) {
        return zlass.getConstructor().newInstance();
      } else {
        return zlass.getConstructor(parameterTypes).newInstance(args);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
