package cool.taomu.box.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class FileTools {
  private static final Logger LOG = LoggerFactory.getLogger(FileTools.class);
  
  public static List<String> scannDirFile(final String path) {
    final ArrayList<String> list = new ArrayList<String>();
    String _trim = path.trim();
    final File dir = new File(_trim);
    boolean _isDirectory = dir.isDirectory();
    if (_isDirectory) {
      final File[] files = dir.listFiles();
      for (final File file : files) {
        boolean _isDirectory_1 = file.isDirectory();
        if (_isDirectory_1) {
          list.addAll(FileTools.scannDirFile(file.getAbsolutePath()));
        } else {
          String f = file.getAbsolutePath();
          FileTools.LOG.info("扫描到的文件:{}", f);
          list.add(f);
        }
      }
    } else {
      list.add(dir.getAbsolutePath());
    }
    return list;
  }
}
