/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.utils;

import cool.taomu.box.utils.inter.ICallback;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class FileTools {
  private static final Logger LOG = LoggerFactory.getLogger(FileTools.class);
  
  public static String getSubdirectory(final String baseDir, final String fullDir, final String separator) {
    String a = fullDir.trim().replace(baseDir.trim(), "").replace(File.separator, separator);
    FileTools.LOG.info("根目录:{},子目录:{}", baseDir, a);
    return a;
  }
  
  public static String getSubdirectory(final String baseDir, final String fullDir) {
    String a = fullDir.trim().replace(baseDir.trim(), "");
    FileTools.LOG.info("根目录:{},子目录:{}", baseDir, a);
    return a;
  }
  
  public static void scanner(final String path, final ICallback<String> ck) {
    Path directoryPath = Paths.get(path);
    try {
      final Predicate<Path> _function = (Path it) -> {
        return Files.isRegularFile(it);
      };
      final Consumer<Path> _function_1 = (Path it) -> {
        ck.call(it.toString());
      };
      Files.walk(directoryPath).filter(_function).forEach(_function_1);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public static void scannerFile(final String path, final ICallback<File> ck) {
    Path directoryPath = Paths.get(path);
    try {
      final Predicate<Path> _function = (Path it) -> {
        return Files.isRegularFile(it);
      };
      final Consumer<Path> _function_1 = (Path it) -> {
        String _string = it.toString();
        File _file = new File(_string);
        ck.call(_file);
      };
      Files.walk(directoryPath).filter(_function).forEach(_function_1);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public static boolean isEmpty(final String path) {
    File file = new File(path);
    boolean empty = true;
    boolean _exists = file.exists();
    boolean _not = (!_exists);
    if (_not) {
      empty = true;
    } else {
      long _length = file.length();
      boolean _equals = (_length == 0);
      if (_equals) {
        empty = true;
      } else {
        empty = false;
      }
    }
    return empty;
  }
  
  public static List<String> scannDirFile(final String path, final String exclude) {
    final ArrayList<String> list = new ArrayList<String>();
    String _trim = path.trim();
    final File dir = new File(_trim);
    boolean _isDirectory = dir.isDirectory();
    if (_isDirectory) {
      final File[] files = dir.listFiles();
      for (final File file : files) {
        boolean _isDirectory_1 = file.isDirectory();
        if (_isDirectory_1) {
          if (((exclude != null) && (!exclude.equals(file.getName())))) {
            list.addAll(FileTools.scannDirFile(file.getAbsolutePath(), exclude));
          } else {
            list.addAll(FileTools.scannDirFile(file.getAbsolutePath(), exclude));
          }
        } else {
          String f = file.getAbsolutePath();
          FileTools.LOG.info("扫描到的文件:{}", f);
          list.add(f);
        }
      }
    } else {
      list.add(dir.getAbsolutePath());
    }
    return list;
  }
}
