/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.utils;

import cool.taomu.box.utils.inter.ICallback;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTools {
    private static final Logger LOG = LoggerFactory.getLogger(FileTools.class);

    public static String getSubdirectory(String baseDir, String fullDir, String separator) {
        String a = fullDir.trim().replace(baseDir.trim(), "").replace(File.separator, separator);
        LOG.info("\u6839\u76ee\u5f55:{},\u5b50\u76ee\u5f55:{}", (Object)baseDir, (Object)a);
        return a;
    }

    public static String getSubdirectory(String baseDir, String fullDir) {
        String a = fullDir.trim().replace(baseDir.trim(), "");
        LOG.info("\u6839\u76ee\u5f55:{},\u5b50\u76ee\u5f55:{}", (Object)baseDir, (Object)a);
        return a;
    }

    public static void scanner(String path, ICallback<String> ck) {
        Path directoryPath = Paths.get(path, new String[0]);
        try {
            Predicate<Path> _function = it -> Files.isRegularFile(it, new LinkOption[0]);
            Consumer<Path> _function_1 = it -> ck.call(it.toString());
            Files.walk(directoryPath, new FileVisitOption[0]).filter(_function).forEach(_function_1);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static void scannerFile(String path, ICallback<File> ck) {
        Path directoryPath = Paths.get(path, new String[0]);
        try {
            Predicate<Path> _function = it -> Files.isRegularFile(it, new LinkOption[0]);
            Consumer<Path> _function_1 = it -> {
                String _string = it.toString();
                File _file = new File(_string);
                ck.call(_file);
            };
            Files.walk(directoryPath, new FileVisitOption[0]).filter(_function).forEach(_function_1);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static boolean isEmpty(String path) {
        boolean _not;
        File file = new File(path);
        boolean empty = true;
        boolean _exists = file.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            empty = true;
        } else {
            long _length = file.length();
            boolean _equals = _length == 0L;
            empty = _equals;
        }
        return empty;
    }

    public static List<String> scannDirFile(String path, String exclude) {
        ArrayList<String> list = new ArrayList<String>();
        String _trim = path.trim();
        File dir = new File(_trim);
        boolean _isDirectory = dir.isDirectory();
        if (_isDirectory) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                boolean _isDirectory_1 = file.isDirectory();
                if (_isDirectory_1) {
                    if (exclude != null && !exclude.equals(file.getName())) {
                        list.addAll(FileTools.scannDirFile(file.getAbsolutePath(), exclude));
                        continue;
                    }
                    list.addAll(FileTools.scannDirFile(file.getAbsolutePath(), exclude));
                    continue;
                }
                String f = file.getAbsolutePath();
                LOG.info("\u626b\u63cf\u5230\u7684\u6587\u4ef6:{}", (Object)f);
                list.add(f);
            }
        } else {
            list.add(dir.getAbsolutePath());
        }
        return list;
    }
}

