/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.utils;

import cool.taomu.box.utils.inter.ICallback;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTools {
    private static final Logger LOG = LoggerFactory.getLogger(FileTools.class);

    public static String getSubdirectory(String baseDir, String fullDir, String separator) {
        String a = fullDir.trim().replace(baseDir.trim(), "").replace(File.separator, separator);
        LOG.info("\u6839\u76ee\u5f55:{},\u5b50\u76ee\u5f55:{}", (Object)baseDir, (Object)a);
        return a;
    }

    public static String getSubdirectory(String baseDir, String fullDir) {
        String a = fullDir.trim().replace(baseDir.trim(), "");
        LOG.info("\u6839\u76ee\u5f55:{},\u5b50\u76ee\u5f55:{}", (Object)baseDir, (Object)a);
        return a;
    }

    public static void scanner(String path, ICallback<String> ck) {
        Path directoryPath = Paths.get(path, new String[0]);
        try {
            Predicate<Path> _function = it -> Files.isRegularFile(it, new LinkOption[0]);
            Consumer<Path> _function_1 = it -> ck.call(it.toString());
            Files.walk(directoryPath, new FileVisitOption[0]).filter(_function).forEach(_function_1);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static void fileDelete(Path tempDir) {
        try {
            Comparator _function = (o1, o2) -> o2.compareTo((Path)o1);
            Function<Path, File> _function_1 = it -> it.toFile();
            Consumer<File> _function_2 = it -> it.delete();
            Files.walk(tempDir, new FileVisitOption[0]).sorted(_function).map(_function_1).forEach(_function_2);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void scannerFile(String path, ICallback<File> ck) {
        Path directoryPath = Paths.get(path, new String[0]);
        try {
            Predicate<Path> _function = it -> Files.isRegularFile(it, new LinkOption[0]);
            Consumer<Path> _function_1 = it -> {
                String _string = it.toString();
                File _file = new File(_string);
                ck.call(_file);
            };
            Files.walk(directoryPath, new FileVisitOption[0]).filter(_function).forEach(_function_1);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static boolean isEmpty(String path) {
        boolean _not;
        File file = new File(path);
        boolean empty = true;
        boolean _exists = file.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            empty = true;
        } else {
            long _length = file.length();
            boolean _equals = _length == 0L;
            empty = _equals;
        }
        return empty;
    }

    public static List<String> scannDirFile(String path, String exclude) {
        ArrayList<String> list = new ArrayList<String>();
        String _trim = path.trim();
        File dir = new File(_trim);
        boolean _isDirectory = dir.isDirectory();
        if (_isDirectory) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                boolean _isDirectory_1 = file.isDirectory();
                if (_isDirectory_1) {
                    if (exclude != null && !exclude.equals(file.getName())) {
                        list.addAll(FileTools.scannDirFile(file.getAbsolutePath(), exclude));
                        continue;
                    }
                    list.addAll(FileTools.scannDirFile(file.getAbsolutePath(), exclude));
                    continue;
                }
                String f = file.getAbsolutePath();
                LOG.info("\u626b\u63cf\u5230\u7684\u6587\u4ef6:{}", (Object)f);
                list.add(f);
            }
        } else {
            list.add(dir.getAbsolutePath());
        }
        return list;
    }

    public static ArrayList<String> directoryTree(String path) {
        File root = new File(path);
        ArrayList<String> dirList = new ArrayList<String>();
        if (root.exists() && root.isDirectory()) {
            FileTools.showDriectoryTree(root, 0, dirList);
        } else {
            dirList.add("\u65e0\u6548\u7684\u76ee\u5f55\u8def\u5f84: " + path);
        }
        return dirList;
    }

    private static void showDriectoryTree(File dir, int indent, List<String> res) {
        String indents = "  ";
        for (int i = 0; i < indent; ++i) {
            String _indents = indents;
            indents = _indents + "  ";
        }
        String _name = dir.getName();
        res.add(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{indents, "|-- ", _name})), (CharSequence)""));
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                boolean _isDirectory = file.isDirectory();
                if (_isDirectory) {
                    FileTools.showDriectoryTree(file, indent + 1, res);
                    continue;
                }
                indents = "  ";
                for (int i = 0; i < indent + 1; ++i) {
                    String _indents = indents;
                    indents = _indents + "  ";
                }
                String _name_1 = file.getName();
                res.add(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{indents, "|-- ", _name_1})), (CharSequence)""));
            }
        }
    }
}

