/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.utils;

import com.google.common.collect.ArrayListMultimap;
import cool.taomu.box.crypto.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.yaml.snakeyaml.Yaml;

@SuppressWarnings("all")
public class YamlUitls {
  public Properties toProperties(final String filename) {
    try {
      final ArrayListMultimap<String, Object> m = ArrayListMultimap.<String, Object>create();
      Yaml yml = new Yaml();
      Map results = yml.<Map>loadAs(TaomuResource.read(filename), Map.class);
      final BiConsumer<String, Object> _function = (String k, Object v) -> {
        if ((v instanceof Map)) {
          this.toProperty(m, k, ((Map<String, Object>)v));
        } else {
          if ((v instanceof List)) {
            final Consumer<Map<String, Object>> _function_1 = (Map<String, Object> it) -> {
              this.toProperty(m, k, it);
            };
            ((List)v).forEach(_function_1);
          } else {
            m.put(k, v);
          }
        }
      };
      results.forEach(_function);
      final File pfile = File.createTempFile(UUID.randomUUID().toString(), ".properties");
      final Properties pro = new Properties();
      final BiConsumer<String, Collection<Object>> _function_1 = (String k, Collection<Object> v1) -> {
        try {
          Perl5Util p5 = new Perl5Util();
          Object v = ((Object[])Conversions.unwrapArray(v1, Object.class))[0];
          if (((v instanceof String) && p5.match("/^ENC\\(([^?.]*)\\)$/", ((String) v)))) {
            byte[] _bytes = p5.group(1).getBytes();
            byte[] _decode = new Base64(_bytes).decode();
            String dev = new String(_decode, "UTF-8");
            String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(k, dev)), "=");
            String _plus = (_join + "\n");
            FileUtils.writeStringToFile(pfile, _plus, "UTF-8", true);
          } else {
            if ((v1 instanceof List)) {
              String _join_1 = IterableExtensions.join(v1, ",");
              String _join_2 = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(k, _join_1)), "=");
              String _plus_1 = (_join_2 + "\n");
              FileUtils.writeStringToFile(pfile, _plus_1, "UTF-8", true);
            } else {
              String _join_3 = IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(k, v)), "=");
              String _plus_2 = (_join_3 + "\n");
              FileUtils.writeStringToFile(pfile, _plus_2, "UTF-8", true);
            }
          }
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      m.asMap().forEach(_function_1);
      try (FileInputStream in = new Function0<FileInputStream>() {
        @Override
        public FileInputStream apply() {
          try {
            return new FileInputStream(pfile);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        pro.load(in);
        pfile.delete();
      }
      return pro;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void toProperty(final ArrayListMultimap<String, Object> convert, final String key, final Map<String, Object> map) {
    final BiConsumer<String, Object> _function = (String k, Object v) -> {
      String _xifexpression = null;
      boolean _isNotBlank = StringUtils.isNotBlank(key);
      if (_isNotBlank) {
        _xifexpression = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(key, k)), ".");
      } else {
        _xifexpression = k;
      }
      final String namespace = _xifexpression;
      if ((v instanceof Map)) {
        this.toProperty(convert, namespace, ((Map<String, Object>)v));
      } else {
        if ((v instanceof List)) {
          final Consumer<Object> _function_1 = (Object it) -> {
            if ((it instanceof Map)) {
              this.toProperty(convert, namespace, ((Map<String, Object>)it));
            } else {
              boolean _containsKey = convert.containsKey(namespace);
              if (_containsKey) {
                convert.put(namespace, it);
              } else {
                convert.put(namespace, it);
              }
            }
          };
          ((List)v).forEach(_function_1);
        } else {
          convert.put(namespace, v);
        }
      }
    };
    map.forEach(_function);
  }
}
