/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.crypto;

import cool.taomu.box.crypto.util.PgpUtils;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@SuppressWarnings("all")
public class SimplePgp extends AbsCrypto {
  private String key;
  
  private String pass;
  
  public SimplePgp(final byte[] src, final String publicKey) {
    BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
    Security.addProvider(_bouncyCastleProvider);
    this.src = src;
    this.key = publicKey;
  }
  
  public SimplePgp(final byte[] src, final String privateKey, final String passwd) {
    BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
    Security.addProvider(_bouncyCastleProvider);
    this.src = src;
    this.key = privateKey;
    this.pass = passwd;
  }
  
  public SimplePgp(final ICrypto c, final String publicKey) {
    BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
    Security.addProvider(_bouncyCastleProvider);
    this.c = c;
    this.key = publicKey;
  }
  
  public SimplePgp(final ICrypto c, final String privateKey, final String passwd) {
    BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
    Security.addProvider(_bouncyCastleProvider);
    this.c = c;
    this.key = privateKey;
    this.pass = passwd;
  }
  
  @Override
  public byte[] decode() {
    if ((this.c != null)) {
      byte[] bytes = PgpUtils.decrypt(this.c.getData(), this.key, this.pass);
      this.c.setData(bytes);
      return this.c.decode();
    } else {
      return PgpUtils.decrypt(this.src, this.key, this.pass);
    }
  }
  
  @Override
  public byte[] encode() {
    if ((this.c != null)) {
      return PgpUtils.encrypt(this.c.encode(), this.key, true);
    } else {
      return PgpUtils.encrypt(this.src, this.key, true);
    }
  }
  
  @Pure
  public String getKey() {
    return this.key;
  }
  
  public void setKey(final String key) {
    this.key = key;
  }
  
  @Pure
  public String getPass() {
    return this.pass;
  }
  
  public void setPass(final String pass) {
    this.pass = pass;
  }
}
