/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.crypto;

@SuppressWarnings("all")
public class Base64 extends AbsCrypto {
  public Base64(final byte[] src) {
    this.src = src;
  }
  
  public Base64(final ICrypto c) {
    this.c = c;
  }
  
  @Override
  public byte[] encode() {
    if ((this.c != null)) {
      return org.apache.commons.codec.binary.Base64.encodeBase64(this.c.encode());
    }
    return org.apache.commons.codec.binary.Base64.encodeBase64(this.src);
  }
  
  @Override
  public byte[] decode() {
    if ((this.c != null)) {
      byte[] base64Src = org.apache.commons.codec.binary.Base64.decodeBase64(this.c.getData());
      this.c.setData(base64Src);
      return this.c.decode();
    } else {
      return org.apache.commons.codec.binary.Base64.decodeBase64(this.src);
    }
  }
}
