/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.crypto;

import cool.taomu.box.crypto.AbsCrypto;
import cool.taomu.box.crypto.ICrypto;
import cool.taomu.box.crypto.util.PgpUtils;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class SimplePgp
extends AbsCrypto {
    private String key;
    private String pass;

    public SimplePgp(byte[] src, String publicKey) {
        BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)_bouncyCastleProvider);
        this.src = src;
        this.key = publicKey;
    }

    public SimplePgp(byte[] src, String privateKey, String passwd) {
        BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)_bouncyCastleProvider);
        this.src = src;
        this.key = privateKey;
        this.pass = passwd;
    }

    public SimplePgp(ICrypto c, String publicKey) {
        BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)_bouncyCastleProvider);
        this.c = c;
        this.key = publicKey;
    }

    public SimplePgp(ICrypto c, String privateKey, String passwd) {
        BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)_bouncyCastleProvider);
        this.c = c;
        this.key = privateKey;
        this.pass = passwd;
    }

    @Override
    public byte[] decode() {
        if (this.c != null) {
            byte[] bytes = PgpUtils.decrypt(this.c.getData(), this.key, this.pass);
            this.c.setData(bytes);
            return this.c.decode();
        }
        return PgpUtils.decrypt(this.src, this.key, this.pass);
    }

    @Override
    public byte[] encode() {
        if (this.c != null) {
            return PgpUtils.encrypt(this.c.encode(), this.key, true);
        }
        return PgpUtils.encrypt(this.src, this.key, true);
    }

    @Pure
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Pure
    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }
}

