/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.crypto.util;

import cool.taomu.box.crypto.Base64;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.Streams;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PgpUtils.class);

    public static void main(String[] args) {
        try {
            BouncyCastleProvider _bouncyCastleProvider = new BouncyCastleProvider();
            Security.addProvider((Provider)_bouncyCastleProvider);
            File _file = new File("src/test/resources/publicKey1.txt");
            String pk = FileUtils.readFileToString((File)_file, (Charset)Charset.forName("UTF-8"));
            byte[] data = PgpUtils.encrypt("Hello World!!!! ".getBytes(), pk, true);
            String _string = new String(data, "UTF-8");
            InputOutput.println((Object)_string);
            File _file_1 = new File("src/test/resources/privateKey1.txt");
            String prk = FileUtils.readFileToString((File)_file_1, (Charset)Charset.forName("UTF-8"));
            byte[] d = PgpUtils.decrypt(data, prk, "123456789");
            String _string_1 = new String(d, "UTF-8");
            String _plus = "result : " + _string_1;
            InputOutput.println((Object)_plus);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] decrypt(byte[] data, String privateKey, String password) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            byte[] byArray;
            InputStream input = PGPUtil.getDecoderStream((InputStream)bais);
            JcaPGPObjectFactory jpof = new JcaPGPObjectFactory(input);
            Object o = jpof.nextObject();
            PGPEncryptedDataList enc = null;
            if (o instanceof PGPEncryptedDataList) {
                enc = (PGPEncryptedDataList)o;
            } else {
                Object _nextObject = jpof.nextObject();
                enc = (PGPEncryptedDataList)_nextObject;
            }
            byte[] _bytes = privateKey.getBytes();
            byte[] pkeyBase64 = new Base64(_bytes).decode();
            JcaKeyFingerprintCalculator _jcaKeyFingerprintCalculator = new JcaKeyFingerprintCalculator();
            PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(pkeyBase64, (KeyFingerPrintCalculator)_jcaKeyFingerprintCalculator);
            Iterator edo = enc.getEncryptedDataObjects();
            Functions.Function1 _function = k -> {
                try {
                    PGPSecretKey _secretKey = pgpSec.getSecretKey(((PGPPublicKeyEncryptedData)k).getKeyID());
                    return _secretKey != null;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            PGPEncryptedData _findFirst = (PGPEncryptedData)IteratorExtensions.findFirst((Iterator)edo, (Functions.Function1)_function);
            PGPPublicKeyEncryptedData pbe = (PGPPublicKeyEncryptedData)_findFirst;
            PGPSecretKey secKey = pgpSec.getSecretKey(pbe.getKeyID());
            PBESecretKeyDecryptor jpekdb = new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(password.toCharArray());
            PGPPrivateKey sKey = secKey.extractPrivateKey(jpekdb);
            InputStream clear = pbe.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(sKey));
            JcaPGPObjectFactory plain = new JcaPGPObjectFactory(clear);
            Object message = plain.nextObject();
            if (input != null) {
                input.close();
            }
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                if (message instanceof PGPCompressedData) {
                    InputStream _dataStream = ((PGPCompressedData)message).getDataStream();
                    JcaPGPObjectFactory fact = new JcaPGPObjectFactory(_dataStream);
                    message = fact.nextObject();
                }
                if (message instanceof PGPLiteralData) {
                    Streams.pipeAll((InputStream)((PGPLiteralData)message).getInputStream(), (OutputStream)out);
                } else if (message instanceof PGPOnePassSignatureList) {
                    LOG.info("encrypted message contains a signed message - not literal data.");
                } else if (message instanceof PGPSignatureList) {
                    LOG.info("encrypted message contains a signed message - not literal data.");
                }
                boolean _isIntegrityProtected = pbe.isIntegrityProtected();
                if (_isIntegrityProtected) {
                    boolean _not;
                    boolean _verify = pbe.verify();
                    boolean bl = _not = !_verify;
                    if (_not) {
                        LOG.info("message failed integrity check");
                    } else {
                        LOG.info("message integrity check passed");
                    }
                } else {
                    LOG.info("no message integrity check");
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static byte[] encrypt(byte[] data, String publicKey, boolean withIntegrityCheck) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            PgpUtils.encrypt(data, publicKey, withIntegrityCheck, out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        out.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encrypt(byte[] data, String publicKey, boolean withIntegrityCheck, OutputStream out) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(new Base64(publicKey.getBytes()).decode());){
            InputStream input = PGPUtil.getDecoderStream((InputStream)bais);
            JcaKeyFingerprintCalculator _jcaKeyFingerprintCalculator = new JcaKeyFingerprintCalculator();
            PGPPublicKeyRingCollection pkrc = new PGPPublicKeyRingCollection(input, (KeyFingerPrintCalculator)_jcaKeyFingerprintCalculator);
            Functions.Function1 _function = it -> {
                Functions.Function1 _function_1 = it_1 -> it_1.isEncryptionKey();
                return ((PGPPublicKey)IteratorExtensions.findFirst((Iterator)it.getPublicKeys(), (Functions.Function1)_function_1)).isEncryptionKey();
            };
            PGPPublicKey encKey = ((PGPPublicKeyRing)IteratorExtensions.findFirst((Iterator)pkrc.getKeyRings(), (Functions.Function1)_function)).getPublicKey();
            File file = CreateTempFile.create(data, "UTF-8");
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                PGPCompressedDataGenerator cdg = new PGPCompressedDataGenerator(1);
                PGPUtil.writeFileToLiteralData((OutputStream)cdg.open((OutputStream)baos), (char)'b', (File)file);
                cdg.close();
                byte[] bytes = baos.toByteArray();
                JcePGPDataEncryptorBuilder jpdeb = new JcePGPDataEncryptorBuilder(3);
                jpdeb = jpdeb.setWithIntegrityPacket(withIntegrityCheck);
                SecureRandom _secureRandom = new SecureRandom();
                JcePGPDataEncryptorBuilder bc = jpdeb.setSecureRandom(_secureRandom).setProvider("BC");
                PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)bc);
                JcePublicKeyKeyEncryptionMethodGenerator _jcePublicKeyKeyEncryptionMethodGenerator = new JcePublicKeyKeyEncryptionMethodGenerator(encKey);
                encGen.addMethod((PGPKeyEncryptionMethodGenerator)_jcePublicKeyKeyEncryptionMethodGenerator.setProvider("BC"));
                try (OutputStream cout = PgpUtils.encGenOpen(encGen, out, bytes);){
                    cout.write(bytes);
                }
            }
            finally {
                file.delete();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static OutputStream encGenOpen(PGPEncryptedDataGenerator encGen, OutputStream out, byte[] bytes) {
        try {
            return encGen.open(out, (long)bytes.length);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static class CreateTempFile {
        public static File create(byte[] content, String charset) {
            Charset _forName = Charset.forName(charset);
            String _string = new String(content, _forName);
            return CreateTempFile.create(_string);
        }

        public static File create(String content) {
            try {
                String tempName = UUID.randomUUID().toString();
                final File temp = File.createTempFile(tempName, ".temp");
                temp.deleteOnExit();
                try (BufferedWriter bw = new Functions.Function0<BufferedWriter>(){

                    public BufferedWriter apply() {
                        try {
                            FileWriter _fileWriter = new FileWriter(temp);
                            return new BufferedWriter(_fileWriter);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                }.apply();){
                    bw.write(content);
                }
                return temp;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        public static File create(byte[] content) {
            try {
                String tempName = UUID.randomUUID().toString();
                File temp = File.createTempFile(tempName, ".temp");
                temp.deleteOnExit();
                FileUtils.writeByteArrayToFile((File)temp, (byte[])content);
                return temp;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }
}

