/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.datasource;

import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class C3p0DataSourceProvider implements Provider<DataSource> {
  private ComboPooledDataSource dataSource = new ComboPooledDataSource();
  
  @Inject
  public void setDirver(@Named("c3p0.jdbc.driver") final String driverCLass) {
    try {
      this.dataSource.setDriverClass(driverCLass);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Inject
  public void setJdbcUrl(@Named("c3p0.jdbc.url") final String url) {
    this.dataSource.setJdbcUrl(url);
  }
  
  @Inject
  public void setUname(@Named("c3p0.jdbc.username") final String uname) {
    this.dataSource.setUser(uname);
  }
  
  @Inject
  public void setPasswd(@Named("c3p0.jdbc.password") final String pwd) {
    this.dataSource.setPassword(pwd);
  }
  
  @Inject
  public void maxPoolSize(@Named("c3p0.maxPoolSize") final int value) {
    this.dataSource.setMaxPoolSize(value);
  }
  
  @Inject
  public void testConnectionOnCheckin(@Named("c3p0.testConnectionOnCheckin") final boolean value) {
    this.dataSource.setTestConnectionOnCheckin(value);
  }
  
  @Inject
  public void testConnectionOnCheckout(@Named("c3p0.testConnectionOnCheckout") final boolean value) {
    this.dataSource.setTestConnectionOnCheckout(value);
  }
  
  @Inject
  public void minPoolSize(@Named("c3p0.minPoolSize") final int value) {
    this.dataSource.setMinPoolSize(value);
  }
  
  @Inject
  public void breakAfterAcquireFailure(@Named("c3p0.breakAfterAcquireFailure") final boolean value) {
    this.dataSource.setBreakAfterAcquireFailure(value);
  }
  
  @Inject
  public void setAcquireIncrement(@Named("c3p0.acquireIncrement") final int value) {
    this.dataSource.setAcquireIncrement(value);
  }
  
  @Inject
  public void setInitialSize(@Named("c3p0.initialPoolSize") final int value) {
    this.dataSource.setInitialPoolSize(value);
  }
  
  @Inject
  public void acquireRetryAttempts(@Named("c3p0.acquireRetryAttempts") final int value) {
    this.dataSource.setAcquireRetryAttempts(value);
  }
  
  @Inject
  public void acquireRetryDelay(@Named("c3p0.acquireRetryDelay") final int value) {
    this.dataSource.setAcquireRetryDelay(value);
  }
  
  @Inject
  public void autoCommitOnClose(@Named("c3p0.autoCommitOnClose") final boolean value) {
    this.dataSource.setAutoCommitOnClose(value);
  }
  
  @Inject
  public void automaticTestTable(@Named("c3p0.automaticTestTable") final String value) {
    this.dataSource.setAutomaticTestTable(value);
  }
  
  @Inject
  public void checkoutTimeout(@Named("c3p0.checkoutTimeout") final int value) {
    this.dataSource.setCheckoutTimeout(value);
  }
  
  @Inject
  public void dataSourceName(@Named("c3p0.dataSourceName") final String value) {
    this.dataSource.setDataSourceName(value);
  }
  
  @Inject
  public void loginTimeout(@Named("c3p0.loginTimeout") final int value) {
    try {
      this.dataSource.setLoginTimeout(value);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Inject
  public void maxConnectionAge(@Named("c3p0.maxConnectionAge") final int value) {
    this.dataSource.setMaxConnectionAge(value);
  }
  
  @Inject
  public void maxIdleTime(@Named("c3p0.maxIdleTime") final int value) {
    this.dataSource.setMaxIdleTime(value);
  }
  
  @Inject
  public void maxIdleTimeExcessConnections(@Named("c3p0.maxIdleTimeExcessConnections") final int value) {
    this.dataSource.setMaxIdleTimeExcessConnections(value);
  }
  
  @Override
  public DataSource get() {
    return this.dataSource;
  }
}
