/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.datasource;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

@SuppressWarnings("all")
public class Dbcp2DataSourceProvider implements Provider<DataSource> {
  private BasicDataSource dataSource = new BasicDataSource();
  
  @Inject
  public void setDirver(@Named("dbcp2.jdbc.driver") final String driverCLass) {
    this.dataSource.setDriverClassName(driverCLass);
  }
  
  @Inject
  public void setJdbcUrl(@Named("dbcp2.jdbc.url") final String url) {
    this.dataSource.setUrl(url);
  }
  
  @Inject
  public void setUname(@Named("dbcp2.jdbc.username") final String uname) {
    this.dataSource.setUsername(uname);
  }
  
  @Inject
  public void setPasswd(@Named("dbcp2.jdbc.password") final String pwd) {
    this.dataSource.setPassword(pwd);
  }
  
  @Inject(optional = true)
  public void autoCommit(@Named("dbcp2.autoCommit") final boolean value) {
    this.dataSource.setDefaultAutoCommit(Boolean.valueOf(value));
  }
  
  @Inject(optional = true)
  public void readOnly(@Named("dbcp2.readOnly") final boolean value) {
    this.dataSource.setDefaultReadOnly(Boolean.valueOf(value));
  }
  
  @Inject(optional = true)
  public void transactionIsolation(@Named("dbcp2.transactionIsolation") final Integer value) {
    this.dataSource.setDefaultTransactionIsolation((value).intValue());
  }
  
  @Inject(optional = true)
  public void defaultCatalog(@Named("dbcp2.defaultCatalog") final String value) {
    this.dataSource.setDefaultCatalog(value);
  }
  
  @Inject(optional = true)
  public void initialSize(@Named("dbcp2.initialSize") final int value) {
    this.dataSource.setInitialSize(value);
  }
  
  @Inject(optional = true)
  public void maxActive(@Named("dbcp2.maxTotal") final int value) {
    this.dataSource.setMaxTotal(value);
  }
  
  @Inject(optional = true)
  public void minIdle(@Named("dbcp2.minIdle") final int value) {
    this.dataSource.setMinIdle(value);
  }
  
  @Inject(optional = true)
  public void maxIdle(@Named("dbcp2.maxIdle") final int value) {
    this.dataSource.setMaxIdle(value);
  }
  
  @Inject(optional = true)
  public void maxWait(@Named("dbcp2.maxWaitMillis") final long value) {
    this.dataSource.setMaxWaitMillis(value);
  }
  
  @Inject(optional = true)
  public void validationQuery(@Named("dbcp2.validationQuery") final String value) {
    this.dataSource.setValidationQuery(value);
  }
  
  @Inject(optional = true)
  public void validationQueryTimeout(@Named("dbcp2.validationQueryTimeout") final int value) {
    this.dataSource.setValidationQueryTimeout(value);
  }
  
  @Inject(optional = true)
  public void testOnBorrow(@Named("dbcp2.testOnBorrow") final boolean value) {
    this.dataSource.setTestOnBorrow(value);
  }
  
  @Inject(optional = true)
  public void testOnReturn(@Named("dbcp2.testOnReturn") final boolean value) {
    this.dataSource.setTestOnReturn(value);
  }
  
  @Inject(optional = true)
  public void testWhileIdle(@Named("dbcp2.testWhileIdle") final boolean value) {
    this.dataSource.setTestWhileIdle(value);
  }
  
  @Inject(optional = true)
  public void poolPreparedStatements(@Named("dbcp2.poolPreparedStatements") final boolean value) {
    this.dataSource.setPoolPreparedStatements(value);
  }
  
  @Inject(optional = true)
  public void accessToUnderlyingConnectionAllowed(@Named("dbcp2.accessToUnderlyingConnectionAllowed") final boolean value) {
    this.dataSource.setAccessToUnderlyingConnectionAllowed(value);
  }
  
  @Inject(optional = true)
  public void timeBetweenEvictionRunsMillis(@Named("dbcp2.timeBetweenEvictionRunsMillis") final long value) {
    this.dataSource.setTimeBetweenEvictionRunsMillis(value);
  }
  
  @Inject(optional = true)
  public void minEvictableIdleTimeMillis(@Named("dbcp2.minEvictableIdleTimeMillis") final long value) {
    this.dataSource.setMinEvictableIdleTimeMillis(value);
  }
  
  @Inject(optional = true)
  public void logAbandoned(@Named("dbcp2.logAbandoned") final boolean value) {
    this.dataSource.setLogAbandoned(value);
  }
  
  @Inject(optional = true)
  public void maxOpenPreparedStatements(@Named("dbcp2.maxOpenPreparedStatements") final int value) {
    this.dataSource.setMaxOpenPreparedStatements(value);
  }
  
  public void configure(final BasicDataSource dataSource) {
  }
  
  @Override
  public DataSource get() {
    this.configure(this.dataSource);
    return this.dataSource;
  }
}
