/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import javax.sql.DataSource;

@SuppressWarnings("all")
public class DruidDataSourceProvider implements Provider<DataSource> {
  private DruidDataSource dataSource = new DruidDataSource();
  
  @Inject
  public void setDirver(@Named("taomubox.jdbc.driver") final String driverCLass) {
    this.dataSource.setDriverClassName(driverCLass);
  }
  
  @Inject
  public void setJdbcUrl(@Named("taomubox.jdbc.url") final String url) {
    this.dataSource.setUrl(url);
  }
  
  @Inject
  public void setUname(@Named("taomubox.jdbc.username") final String uname) {
    this.dataSource.setUsername(uname);
  }
  
  @Inject
  public void setPasswd(@Named("taomubox.jdbc.password") final String pwd) {
    this.dataSource.setPassword(pwd);
  }
  
  @Inject(optional = true)
  public void autoCommit(@Named("taomubox.jdbc.autoCommit") final boolean value) {
    this.dataSource.setDefaultAutoCommit(value);
  }
  
  @Inject(optional = true)
  public void readOnly(@Named("taomubox.jdbc.readOnly") final boolean value) {
    this.dataSource.setDefaultReadOnly(Boolean.valueOf(value));
  }
  
  @Inject(optional = true)
  public void transactionIsolation(@Named("taomubox.jdbc.transactionIsolation") final Integer value) {
    this.dataSource.setDefaultTransactionIsolation(value);
  }
  
  @Inject(optional = true)
  public void defaultCatalog(@Named("taomubox.jdbc.defaultCatalog") final String value) {
    this.dataSource.setDefaultCatalog(value);
  }
  
  @Inject(optional = true)
  public void name(@Named("taomubox.jdbc.name") final String value) {
    this.dataSource.setName(value);
  }
  
  @Inject(optional = true)
  public void initialSize(@Named("taomubox.jdbc.initialSize") final int value) {
    this.dataSource.setInitialSize(value);
  }
  
  @Inject
  public void maxActive(@Named("taomubox.jdbc.maxActive") final int value) {
    this.dataSource.setMaxActive(value);
  }
  
  @Inject
  public void minIdle(@Named("taomubox.jdbc.minIdle") final int value) {
    this.dataSource.setMinIdle(value);
  }
  
  @Inject
  public void maxWait(@Named("taomubox.jdbc.maxWait") final long value) {
    this.dataSource.setMaxWait(value);
  }
  
  @Inject(optional = true)
  public void notFullTimeoutRetryCount(@Named("taomubox.jdbc.notFullTimeoutRetryCount") final int value) {
    this.dataSource.setNotFullTimeoutRetryCount(value);
  }
  
  @Inject(optional = true)
  public void validationQuery(@Named("taomubox.jdbc.validationQuery") final String value) {
    this.dataSource.setValidationQuery(value);
  }
  
  @Inject(optional = true)
  public void validationQueryTimeout(@Named("taomubox.jdbc.validationQueryTimeout") final int value) {
    this.dataSource.setValidationQueryTimeout(value);
  }
  
  @Inject(optional = true)
  public void testOnBorrow(@Named("taomubox.jdbc.testOnBorrow") final boolean value) {
    this.dataSource.setTestOnBorrow(value);
  }
  
  @Inject(optional = true)
  public void testOnReturn(@Named("taomubox.jdbc.testOnReturn") final boolean value) {
    this.dataSource.setTestOnReturn(value);
  }
  
  @Inject(optional = true)
  public void testWhileIdle(@Named("taomubox.jdbc.testWhileIdle") final boolean value) {
    this.dataSource.setTestWhileIdle(value);
  }
  
  @Inject(optional = true)
  public void poolPreparedStatements(@Named("taomubox.jdbc.poolPreparedStatements") final boolean value) {
    this.dataSource.setPoolPreparedStatements(value);
  }
  
  @Inject(optional = true)
  public void sharePreparedStatements(@Named("taomubox.jdbc.sharePreparedStatements") final boolean value) {
    this.dataSource.setSharePreparedStatements(value);
  }
  
  @Inject(optional = true)
  public void maxPoolPreparedStatementPerConnectionSize(@Named("taomubox.jdbc.maxPoolPreparedStatementPerConnectionSize") final int value) {
    this.dataSource.setMaxPoolPreparedStatementPerConnectionSize(value);
  }
  
  @Inject(optional = true)
  public void clearFiltersEnable(@Named("taomubox.jdbc.clearFiltersEnable") final boolean value) {
    this.dataSource.setClearFiltersEnable(value);
  }
  
  @Inject(optional = true)
  public void queryTimeout(@Named("taomubox.jdbc.queryTimeout") final int value) {
    this.dataSource.setQueryTimeout(value);
  }
  
  @Inject(optional = true)
  public void transactionQueryTimeout(@Named("taomubox.jdbc.transactionQueryTimeout") final int value) {
    this.dataSource.setTransactionQueryTimeout(value);
  }
  
  @Inject(optional = true)
  public void maxWaitThreadCount(@Named("taomubox.jdbc.maxWaitThreadCount") final int value) {
    this.dataSource.setMaxWaitThreadCount(value);
  }
  
  @Inject(optional = true)
  public void accessToUnderlyingConnectionAllowed(@Named("taomubox.jdbc.accessToUnderlyingConnectionAllowed") final boolean value) {
    this.dataSource.setAccessToUnderlyingConnectionAllowed(value);
  }
  
  @Inject(optional = true)
  public void timeBetweenEvictionRunsMillis(@Named("taomubox.jdbc.timeBetweenEvictionRunsMillis") final long value) {
    this.dataSource.setTimeBetweenEvictionRunsMillis(value);
  }
  
  @Inject(optional = true)
  public void minEvictableIdleTimeMillis(@Named("taomubox.jdbc.minEvictableIdleTimeMillis") final long value) {
    this.dataSource.setMinEvictableIdleTimeMillis(value);
  }
  
  @Inject(optional = true)
  public void maxEvictableIdleTimeMillis(@Named("taomubox.jdbc.maxEvictableIdleTimeMillis") final long value) {
    this.dataSource.setMaxEvictableIdleTimeMillis(value);
  }
  
  @Inject(optional = true)
  public void phyTimeoutMillis(@Named("taomubox.jdbc.phyTimeoutMillis") final long value) {
    this.dataSource.setPhyTimeoutMillis(value);
  }
  
  @Inject(optional = true)
  public void removeAbandoned(@Named("taomubox.jdbc.removeAbandoned") final boolean value) {
    this.dataSource.setRemoveAbandoned(value);
  }
  
  @Inject(optional = true)
  public void removeAbandonedTimeoutMillis(@Named("taomubox.jdbc.removeAbandonedTimeoutMillis") final long value) {
    this.dataSource.setRemoveAbandonedTimeoutMillis(value);
  }
  
  @Inject(optional = true)
  public void logAbandoned(@Named("taomubox.jdbc.logAbandoned") final boolean value) {
    this.dataSource.setLogAbandoned(value);
  }
  
  @Inject(optional = true)
  public void maxOpenPreparedStatements(@Named("taomubox.jdbc.maxOpenPreparedStatements") final int value) {
    this.dataSource.setMaxOpenPreparedStatements(value);
  }
  
  @Inject(optional = true)
  public void timeBetweenConnectErrorMillis(@Named("taomubox.jdbc.timeBetweenConnectErrorMillis") final long value) {
    this.dataSource.setTimeBetweenConnectErrorMillis(value);
  }
  
  public void configure(final DruidDataSource dataSource) {
  }
  
  @Override
  public DataSource get() {
    this.configure(this.dataSource);
    return this.dataSource;
  }
}
