/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.datasource;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;

@SuppressWarnings("all")
public class HikariDataSourceProvider implements Provider<DataSource> {
  private HikariDataSource dataSource = new HikariDataSource();
  
  @Inject
  public void setDirver(@Named("hikari.jdbc.driver") final String driverCLass) {
    this.dataSource.setDriverClassName(driverCLass);
  }
  
  @Inject
  public void setJdbcUrl(@Named("hikari.jdbc.url") final String url) {
    this.dataSource.setJdbcUrl(url);
  }
  
  @Inject
  public void setUname(@Named("hikari.jdbc.username") final String uname) {
    this.dataSource.setUsername(uname);
  }
  
  @Inject
  public void setPasswd(@Named("hikari.jdbc.password") final String pwd) {
    this.dataSource.setPassword(pwd);
  }
  
  @Inject
  public void connectionTimeout(@Named("hikari.connectionTimeout") final long value) {
    this.dataSource.setConnectionTimeout(value);
  }
  
  @Inject
  public void validationTimeout(@Named("hikari.validationTimeout") final long value) {
    this.dataSource.setValidationTimeout(value);
  }
  
  @Inject
  public void idleTimeout(@Named("hikari.idleTimeout") final long value) {
    this.dataSource.setIdleTimeout(value);
  }
  
  @Inject
  public void maxLifetime(@Named("hikari.maxLifetime") final long value) {
    this.dataSource.setMaxLifetime(value);
  }
  
  @Inject
  public void maxPoolSize(@Named("hikari.maxPoolSize") final int value) {
    this.dataSource.setMaximumPoolSize(value);
  }
  
  @Inject
  public void minIdle(@Named("hikari.minIdle") final int value) {
    this.dataSource.setMinimumIdle(value);
  }
  
  @Inject(optional = true)
  public void leakDetectionThreshold(@Named("hikari.leakDetectionThreshold") final long value) {
    this.dataSource.setLeakDetectionThreshold(value);
  }
  
  @Inject(optional = true)
  public void initializationFailTimeout(@Named("hikari.initializationFailTimeout") final long value) {
    this.dataSource.setInitializationFailTimeout(value);
  }
  
  @Inject(optional = true)
  public void connectionInitSql(@Named("hikari.connectionInitSql") final String value) {
    this.dataSource.setConnectionInitSql(value);
  }
  
  @Inject(optional = true)
  public void connectionTestQuery(@Named("hikari.connectionTestQuery") final String value) {
    this.dataSource.setConnectionTestQuery(value);
  }
  
  @Inject(optional = true)
  public void dataSourceClassName(@Named("hikari.dataSourceClassName") final String value) {
    this.dataSource.setDataSourceClassName(value);
  }
  
  @Inject(optional = true)
  public void dataSourceJndiName(@Named("hikari.dataSourceJndiName") final String value) {
    this.dataSource.setDataSourceJNDI(value);
  }
  
  @Inject(optional = true)
  public void exceptionOverrideClassName(@Named("hikari.exceptionOverrideClassName") final String value) {
    this.dataSource.setExceptionOverrideClassName(value);
  }
  
  @Inject(optional = true)
  public void poolName(@Named("hikari.poolName") final String value) {
    this.dataSource.setPoolName(value);
  }
  
  @Inject(optional = true)
  public void schema(@Named("hikari.schema") final String value) {
    this.dataSource.setSchema(value);
  }
  
  @Inject(optional = true)
  public void transactionIsolationName(@Named("hikari.transactionIsolationName") final String value) {
    this.dataSource.setTransactionIsolation(value);
  }
  
  @Inject(optional = true)
  public void isAutoCommit(@Named("hikari.autoCommit") final boolean value) {
    this.dataSource.setAutoCommit(value);
  }
  
  @Inject(optional = true)
  public void isReadOnly(@Named("hikari.readOnly") final boolean value) {
    this.dataSource.setReadOnly(value);
  }
  
  @Inject(optional = true)
  public void isIsolateInternalQueries(@Named("hikari.isolateInternalQueries") final boolean value) {
    this.dataSource.setIsolateInternalQueries(value);
  }
  
  @Inject(optional = true)
  public void registerMbeans(@Named("hikari.registerMbeans") final boolean value) {
    this.dataSource.setRegisterMbeans(value);
  }
  
  @Inject(optional = true)
  public void isAllowPoolSuspension(@Named("hikari.allowPoolSuspension") final boolean value) {
    this.dataSource.setAllowPoolSuspension(value);
  }
  
  @Inject(optional = true)
  public void keepaliveTime(@Named("hikari.keepaliveTime") final long value) {
    this.dataSource.setKeepaliveTime(value);
  }
  
  public void configure(final HikariDataSource dataSource) {
  }
  
  @Override
  public DataSource get() {
    this.configure(this.dataSource);
    return this.dataSource;
  }
}
