/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.datasource;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

public class Dbcp2DataSourceProvider
implements Provider<DataSource> {
    private BasicDataSource dataSource = new BasicDataSource();

    @Inject
    public void setDirver(@Named(value="dbcp2.jdbc.driver") String driverCLass) {
        this.dataSource.setDriverClassName(driverCLass);
    }

    @Inject
    public void setJdbcUrl(@Named(value="dbcp2.jdbc.url") String url) {
        this.dataSource.setUrl(url);
    }

    @Inject
    public void setUname(@Named(value="dbcp2.jdbc.username") String uname) {
        this.dataSource.setUsername(uname);
    }

    @Inject
    public void setPasswd(@Named(value="dbcp2.jdbc.password") String pwd) {
        this.dataSource.setPassword(pwd);
    }

    @Inject(optional=true)
    public void autoCommit(@Named(value="dbcp2.autoCommit") boolean value) {
        this.dataSource.setDefaultAutoCommit(Boolean.valueOf(value));
    }

    @Inject(optional=true)
    public void readOnly(@Named(value="dbcp2.readOnly") boolean value) {
        this.dataSource.setDefaultReadOnly(Boolean.valueOf(value));
    }

    @Inject(optional=true)
    public void transactionIsolation(@Named(value="dbcp2.transactionIsolation") Integer value) {
        this.dataSource.setDefaultTransactionIsolation(value.intValue());
    }

    @Inject(optional=true)
    public void defaultCatalog(@Named(value="dbcp2.defaultCatalog") String value) {
        this.dataSource.setDefaultCatalog(value);
    }

    @Inject(optional=true)
    public void initialSize(@Named(value="dbcp2.initialSize") int value) {
        this.dataSource.setInitialSize(value);
    }

    @Inject(optional=true)
    public void maxActive(@Named(value="dbcp2.maxTotal") int value) {
        this.dataSource.setMaxTotal(value);
    }

    @Inject(optional=true)
    public void minIdle(@Named(value="dbcp2.minIdle") int value) {
        this.dataSource.setMinIdle(value);
    }

    @Inject(optional=true)
    public void maxIdle(@Named(value="dbcp2.maxIdle") int value) {
        this.dataSource.setMaxIdle(value);
    }

    @Inject(optional=true)
    public void maxWait(@Named(value="dbcp2.maxWaitMillis") long value) {
        this.dataSource.setMaxWaitMillis(value);
    }

    @Inject(optional=true)
    public void validationQuery(@Named(value="dbcp2.validationQuery") String value) {
        this.dataSource.setValidationQuery(value);
    }

    @Inject(optional=true)
    public void validationQueryTimeout(@Named(value="dbcp2.validationQueryTimeout") int value) {
        this.dataSource.setValidationQueryTimeout(value);
    }

    @Inject(optional=true)
    public void testOnBorrow(@Named(value="dbcp2.testOnBorrow") boolean value) {
        this.dataSource.setTestOnBorrow(value);
    }

    @Inject(optional=true)
    public void testOnReturn(@Named(value="dbcp2.testOnReturn") boolean value) {
        this.dataSource.setTestOnReturn(value);
    }

    @Inject(optional=true)
    public void testWhileIdle(@Named(value="dbcp2.testWhileIdle") boolean value) {
        this.dataSource.setTestWhileIdle(value);
    }

    @Inject(optional=true)
    public void poolPreparedStatements(@Named(value="dbcp2.poolPreparedStatements") boolean value) {
        this.dataSource.setPoolPreparedStatements(value);
    }

    @Inject(optional=true)
    public void accessToUnderlyingConnectionAllowed(@Named(value="dbcp2.accessToUnderlyingConnectionAllowed") boolean value) {
        this.dataSource.setAccessToUnderlyingConnectionAllowed(value);
    }

    @Inject(optional=true)
    public void timeBetweenEvictionRunsMillis(@Named(value="dbcp2.timeBetweenEvictionRunsMillis") long value) {
        this.dataSource.setTimeBetweenEvictionRunsMillis(value);
    }

    @Inject(optional=true)
    public void minEvictableIdleTimeMillis(@Named(value="dbcp2.minEvictableIdleTimeMillis") long value) {
        this.dataSource.setMinEvictableIdleTimeMillis(value);
    }

    @Inject(optional=true)
    public void logAbandoned(@Named(value="dbcp2.logAbandoned") boolean value) {
        this.dataSource.setLogAbandoned(value);
    }

    @Inject(optional=true)
    public void maxOpenPreparedStatements(@Named(value="dbcp2.maxOpenPreparedStatements") int value) {
        this.dataSource.setMaxOpenPreparedStatements(value);
    }

    public void configure(BasicDataSource dataSource) {
    }

    public DataSource get() {
        this.configure(this.dataSource);
        return this.dataSource;
    }
}

