/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.dbutils;

import cool.taomu.box.dbutils.Callback;
import cool.taomu.box.dbutils.IDbUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUtils
extends QueryRunner
implements IDbUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DbUtils.class);
    private Connection conn = null;

    public DbUtils(Connection conn) {
        this.conn = conn;
    }

    @Inject
    public DbUtils(DataSource ds) {
        try {
            this.conn = ds.getConnection();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void transaction(Callback cl) {
        block5: {
            try {
                try {
                    LOG.info("\u6267\u884c\u6570\u636e\u5e93\u4e8b\u52a1");
                    this.conn.setAutoCommit(false);
                    cl.execute(this);
                    this.conn.commit();
                }
                catch (Throwable _t) {
                    if (_t instanceof SQLException) {
                        SQLException ex = (SQLException)_t;
                        LOG.info("Sql  exception:", (Throwable)ex);
                        this.conn.rollback();
                        break block5;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    @Override
    public int update(String sql, Object ... args) {
        try {
            LOG.info("sql:{}", (Object)sql);
            return this.update(this.conn, sql, args);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public int[] batch(String sql, List<List<Object>> args) {
        try {
            LOG.info("sql:{}", (Object)sql);
            Object[][] array = new Object[args.size()][0];
            for (int i = 0; i < ((List)Conversions.doWrapArray((Object)array)).size(); ++i) {
                array[i] = args.get(i).toArray();
            }
            return this.batch(this.conn, sql, array);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public <T> List<T> queryEntity(String sql, Class<T> zlass, Object ... args) {
        try {
            LOG.info("sql:{}", (Object)sql);
            List results = null;
            if (zlass != null && !zlass.equals(Map.class)) {
                BeanListHandler _beanListHandler = new BeanListHandler(zlass);
                results = (List)this.query(this.conn, sql, (ResultSetHandler)_beanListHandler, args);
            }
            return results;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public List<Map<String, Object>> queryMap(String sql, Object ... args) {
        try {
            LOG.info("sql:{}", (Object)sql);
            MapListHandler _mapListHandler = new MapListHandler();
            return (List)this.query(this.conn, sql, (ResultSetHandler)_mapListHandler, args);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.conn != null) {
            LOG.info("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5");
            this.conn.close();
        }
    }
}

