/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.dbutils;

import java.util.List;
import java.util.Map;

@SuppressWarnings("all")
public interface IDbUtils extends AutoCloseable {
  void transaction(final Callback cl);
  
  int update(final String sql, final Object... args);
  
  int[] batch(final String sql, final List<List<Object>> args);
  
  <T extends Object> List<T> queryEntity(final String sql, final Class<T> zlass, final Object... args);
  
  List<Map<String, Object>> queryMap(final String sql, final Object... args);
}
