/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import javax.sql.DataSource;

@SuppressWarnings("all")
public class DruidDataSourceProvider implements Provider<DataSource> {
  private DruidDataSource dataSource = new DruidDataSource();
  
  @Inject
  public void setDirver(@Named("druid.jdbc.driver") final String driverCLass) {
    this.dataSource.setDriverClassName(driverCLass);
  }
  
  @Inject
  public void setJdbcUrl(@Named("druid.jdbc.url") final String url) {
    this.dataSource.setUrl(url);
  }
  
  @Inject
  public void setUname(@Named("druid.jdbc.username") final String uname) {
    this.dataSource.setUsername(uname);
  }
  
  @Inject
  public void setPasswd(@Named("druid.jdbc.password") final String pwd) {
    this.dataSource.setPassword(pwd);
  }
  
  @Inject(optional = true)
  public void autoCommit(@Named("druid.autoCommit") final boolean value) {
    this.dataSource.setDefaultAutoCommit(value);
  }
  
  @Inject(optional = true)
  public void readOnly(@Named("druid.readOnly") final boolean value) {
    this.dataSource.setDefaultReadOnly(Boolean.valueOf(value));
  }
  
  @Inject(optional = true)
  public void transactionIsolation(@Named("druid.transactionIsolation") final Integer value) {
    this.dataSource.setDefaultTransactionIsolation(value);
  }
  
  @Inject(optional = true)
  public void defaultCatalog(@Named("druid.defaultCatalog") final String value) {
    this.dataSource.setDefaultCatalog(value);
  }
  
  @Inject(optional = true)
  public void name(@Named("druid.name") final String value) {
    this.dataSource.setName(value);
  }
  
  @Inject(optional = true)
  public void initialSize(@Named("druid.initialSize") final int value) {
    this.dataSource.setInitialSize(value);
  }
  
  @Inject
  public void maxActive(@Named("druid.maxActive") final int value) {
    this.dataSource.setMaxActive(value);
  }
  
  @Inject
  public void minIdle(@Named("druid.minIdle") final int value) {
    this.dataSource.setMinIdle(value);
  }
  
  @Inject
  public void maxWait(@Named("druid.maxWait") final long value) {
    this.dataSource.setMaxWait(value);
  }
  
  @Inject(optional = true)
  public void notFullTimeoutRetryCount(@Named("druid.notFullTimeoutRetryCount") final int value) {
    this.dataSource.setNotFullTimeoutRetryCount(value);
  }
  
  @Inject(optional = true)
  public void validationQuery(@Named("druid.validationQuery") final String value) {
    this.dataSource.setValidationQuery(value);
  }
  
  @Inject(optional = true)
  public void validationQueryTimeout(@Named("druid.validationQueryTimeout") final int value) {
    this.dataSource.setValidationQueryTimeout(value);
  }
  
  @Inject(optional = true)
  public void testOnBorrow(@Named("druid.testOnBorrow") final boolean value) {
    this.dataSource.setTestOnBorrow(value);
  }
  
  @Inject(optional = true)
  public void testOnReturn(@Named("druid.testOnReturn") final boolean value) {
    this.dataSource.setTestOnReturn(value);
  }
  
  @Inject(optional = true)
  public void testWhileIdle(@Named("druid.testWhileIdle") final boolean value) {
    this.dataSource.setTestWhileIdle(value);
  }
  
  @Inject(optional = true)
  public void poolPreparedStatements(@Named("druid.poolPreparedStatements") final boolean value) {
    this.dataSource.setPoolPreparedStatements(value);
  }
  
  @Inject(optional = true)
  public void sharePreparedStatements(@Named("druid.sharePreparedStatements") final boolean value) {
    this.dataSource.setSharePreparedStatements(value);
  }
  
  @Inject(optional = true)
  public void maxPoolPreparedStatementPerConnectionSize(@Named("druid.maxPoolPreparedStatementPerConnectionSize") final int value) {
    this.dataSource.setMaxPoolPreparedStatementPerConnectionSize(value);
  }
  
  @Inject(optional = true)
  public void clearFiltersEnable(@Named("druid.clearFiltersEnable") final boolean value) {
    this.dataSource.setClearFiltersEnable(value);
  }
  
  @Inject(optional = true)
  public void queryTimeout(@Named("druid.queryTimeout") final int value) {
    this.dataSource.setQueryTimeout(value);
  }
  
  @Inject(optional = true)
  public void transactionQueryTimeout(@Named("druid.transactionQueryTimeout") final int value) {
    this.dataSource.setTransactionQueryTimeout(value);
  }
  
  @Inject(optional = true)
  public void maxWaitThreadCount(@Named("druid.maxWaitThreadCount") final int value) {
    this.dataSource.setMaxWaitThreadCount(value);
  }
  
  @Inject(optional = true)
  public void accessToUnderlyingConnectionAllowed(@Named("druid.accessToUnderlyingConnectionAllowed") final boolean value) {
    this.dataSource.setAccessToUnderlyingConnectionAllowed(value);
  }
  
  @Inject(optional = true)
  public void timeBetweenEvictionRunsMillis(@Named("druid.timeBetweenEvictionRunsMillis") final long value) {
    this.dataSource.setTimeBetweenEvictionRunsMillis(value);
  }
  
  @Inject(optional = true)
  public void minEvictableIdleTimeMillis(@Named("druid.minEvictableIdleTimeMillis") final long value) {
    this.dataSource.setMinEvictableIdleTimeMillis(value);
  }
  
  @Inject(optional = true)
  public void maxEvictableIdleTimeMillis(@Named("druid.maxEvictableIdleTimeMillis") final long value) {
    this.dataSource.setMaxEvictableIdleTimeMillis(value);
  }
  
  @Inject(optional = true)
  public void phyTimeoutMillis(@Named("druid.phyTimeoutMillis") final long value) {
    this.dataSource.setPhyTimeoutMillis(value);
  }
  
  @Inject(optional = true)
  public void removeAbandoned(@Named("druid.removeAbandoned") final boolean value) {
    this.dataSource.setRemoveAbandoned(value);
  }
  
  @Inject(optional = true)
  public void removeAbandonedTimeoutMillis(@Named("druid.removeAbandonedTimeoutMillis") final long value) {
    this.dataSource.setRemoveAbandonedTimeoutMillis(value);
  }
  
  @Inject(optional = true)
  public void logAbandoned(@Named("druid.logAbandoned") final boolean value) {
    this.dataSource.setLogAbandoned(value);
  }
  
  @Inject(optional = true)
  public void maxOpenPreparedStatements(@Named("druid.maxOpenPreparedStatements") final int value) {
    this.dataSource.setMaxOpenPreparedStatements(value);
  }
  
  @Inject(optional = true)
  public void timeBetweenConnectErrorMillis(@Named("druid.timeBetweenConnectErrorMillis") final long value) {
    this.dataSource.setTimeBetweenConnectErrorMillis(value);
  }
  
  public void configure(final DruidDataSource dataSource) {
  }
  
  @Override
  public DataSource get() {
    this.configure(this.dataSource);
    return this.dataSource;
  }
}
