/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.git;

import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.ListBranchCommand;

@SuppressWarnings("all")
public interface IJGitTools {
  String clone(final String remoteRepository, final boolean isAllBranches, final String branchOrTag);
  
  void checkout(final String remoteRepository, final String name);
  
  void checkoutBranch(final String remoteRepository, final String name);
  
  void pull(final String remoteRepository, final String remoteBranch);
  
  List<String> branchList(final String remoteRepository, final ListBranchCommand.ListMode mode);
  
  List<String> branchList(final String remoteRepository);
  
  void merge(final String remoteRepository, final String srcName, final String mergeBranch, final String mgs);
  
  void reset(final String remoteRepository, final String objectId);
  
  String logOne(final String remoteRepository);
  
  List<String> logAll(final String remoteRepository);
  
  String fetch(final String remoteRepository, final String branch);
  
  String fetchAll(final String remoteRepository);
  
  String push(final String remoteRepository, final String name, final String branch);
  
  Map<String, String> status(final String remoteRepository);
  
  void revert(final String remoteRepository, final String commitId);
}
