/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.git;

import com.google.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class UPCredentialsProvider implements Provider<CredentialsProvider> {
  private static final Logger LOG = LoggerFactory.getLogger(UPCredentialsProvider.class);
  
  @Inject(optional = true)
  @Named("taomubox.git.username")
  private String username;
  
  @Inject(optional = true)
  @Named("taomubox.git.passwd")
  private String password;
  
  @Override
  public CredentialsProvider get() {
    UPCredentialsProvider.LOG.info("Guice从UPCredentialsProvider中获取UsernamePasswordCredentialsProvider实例");
    UPCredentialsProvider.LOG.info("用户名:{},密码是否为空:{}", this.username, Boolean.valueOf(StringExtensions.isNullOrEmpty(this.password)));
    return new UsernamePasswordCredentialsProvider(this.username, this.password);
  }
}
