/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.git;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import cool.taomu.box.git.IJGitTools;
import cool.taomu.box.utils.FileTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Accessors
public class JGitTools
implements IJGitTools {
    private static final Logger LOG = LoggerFactory.getLogger(JGitTools.class);
    @Inject(optional=true)
    private TransportConfigCallback ssh;
    @Inject(optional=true)
    private CredentialsProvider cp;
    @Inject(optional=true)
    @Named(value="taomubox.git.repository")
    private String repository = "./repository";

    private void credentials(TransportCommand<?, ?> command) {
        if (this.ssh != null) {
            command.setTransportConfigCallback(this.ssh);
        } else if (this.cp != null) {
            command.setCredentialsProvider(this.cp);
        } else {
            LOG.info("GIT\u767b\u9646credentials\u662f\u7a7a\u7684");
        }
    }

    private File getRepository(String remoteRepository) {
        String _join;
        File file;
        boolean _exists;
        boolean _not;
        String projectName = remoteRepository;
        boolean _contains = remoteRepository.contains("/");
        if (_contains) {
            int _lastIndexOf = remoteRepository.lastIndexOf("/");
            int _plus = _lastIndexOf + 1;
            projectName = remoteRepository.substring(_plus);
        }
        boolean bl = _not = !(_exists = (file = new File(_join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{this.repository, projectName})), (CharSequence)File.separator))).exists());
        if (_not) {
            LOG.info("\u521b\u5efa\u76ee\u5f55:{}", (Object)file.getAbsolutePath());
            file.mkdirs();
        }
        return file;
    }

    public void init(String path) {
        try {
            String _trim = path.trim();
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
            File file = new File(_join);
            Repository createRepo = FileRepositoryBuilder.create((File)file);
            if (createRepo != null) {
                createRepo.create();
            }
            createRepo.close();
            LOG.info("\u521d\u59cb\u5316\u672c\u5730\u4ed3\u5e93:{}", (Object)file.getAbsolutePath());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void add(String path) {
        try {
            String _trim = path.trim();
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, "/.git"})));
            File _file = new File(_join);
            Git git = Git.open((File)_file);
            List files = FileTools.scannDirFile((String)path.trim());
            Consumer<String> _function = it -> {
                try {
                    boolean _not;
                    boolean _contains = it.contains(".git");
                    boolean bl = _not = !_contains;
                    if (_not) {
                        LOG.info("\u6dfb\u52a0\u6587\u4ef6:{}", it);
                        String _trim_1 = path.trim();
                        String _plus = _trim_1 + "/";
                        git.add().addFilepattern(it.replace(_plus, "")).call();
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            files.forEach(_function);
            git.close();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ex = (Exception)_t;
                ex.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public void addAndCommit(String path, String msg) {
        try {
            String _trim = path.trim();
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
            File _file = new File(_join);
            Git git = Git.open((File)_file);
            List files = FileTools.scannDirFile((String)path.trim());
            Consumer<String> _function = it -> {
                try {
                    boolean _not;
                    boolean _contains = it.contains(".git");
                    boolean bl = _not = !_contains;
                    if (_not) {
                        LOG.info("\u6dfb\u52a0\u6587\u4ef6:{}", it);
                        String _trim_1 = path.trim();
                        String _plus = _trim_1 + File.separator;
                        git.add().addFilepattern(it.replace(_plus, "")).call();
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            files.forEach(_function);
            git.commit().setMessage(msg).call();
            git.close();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ex = (Exception)_t;
                ex.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public HashMap<StatusType, Set<String>> status(String path, StatusType type) {
        HashMap<StatusType, Set<String>> hashMap;
        block18: {
            HashMap<StatusType, Set<String>> map = new HashMap<StatusType, Set<String>>();
            String _trim = path.trim();
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
            final File file = new File(_join);
            Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            try {
                Status status = git.status().call();
                if (Objects.equal((Object)((Object)type), (Object)((Object)StatusType.ALL)) || Objects.equal((Object)((Object)type), (Object)((Object)StatusType.Added))) {
                    map.put(StatusType.Added, status.getAdded());
                }
                if (Objects.equal((Object)((Object)type), (Object)((Object)StatusType.ALL)) || Objects.equal((Object)((Object)type), (Object)((Object)StatusType.Changed))) {
                    map.put(StatusType.Changed, status.getChanged());
                }
                if (Objects.equal((Object)((Object)type), (Object)((Object)StatusType.ALL)) || Objects.equal((Object)((Object)type), (Object)((Object)StatusType.Conflicting))) {
                    map.put(StatusType.Conflicting, status.getConflicting());
                }
                if (Objects.equal((Object)((Object)type), (Object)((Object)StatusType.ALL)) || Objects.equal((Object)((Object)type), (Object)((Object)StatusType.ConflictingStageState))) {
                    // empty if block
                }
                if (Objects.equal((Object)((Object)type), (Object)((Object)StatusType.ALL)) || Objects.equal((Object)((Object)type), (Object)((Object)StatusType.IgnoredNotInIndex))) {
                    map.put(StatusType.IgnoredNotInIndex, status.getIgnoredNotInIndex());
                }
                if (Objects.equal((Object)((Object)type), (Object)((Object)StatusType.ALL)) || Objects.equal((Object)((Object)type), (Object)((Object)StatusType.Missing))) {
                    map.put(StatusType.Missing, status.getMissing());
                }
                if (Objects.equal((Object)((Object)type), (Object)((Object)StatusType.ALL)) || Objects.equal((Object)((Object)type), (Object)((Object)StatusType.Modified))) {
                    map.put(StatusType.Modified, status.getModified());
                }
                if (Objects.equal((Object)((Object)type), (Object)((Object)StatusType.ALL)) || Objects.equal((Object)((Object)type), (Object)((Object)StatusType.Removed))) {
                    map.put(StatusType.Removed, status.getRemoved());
                }
                if (Objects.equal((Object)((Object)type), (Object)((Object)StatusType.ALL)) || Objects.equal((Object)((Object)type), (Object)((Object)StatusType.UntrackedFiles))) {
                    map.put(StatusType.UntrackedFiles, status.getUntracked());
                }
                if (Objects.equal((Object)((Object)type), (Object)((Object)StatusType.ALL)) || Objects.equal((Object)((Object)type), (Object)((Object)StatusType.UntrackedFolders))) {
                    map.put(StatusType.UntrackedFolders, status.getUntrackedFolders());
                }
                hashMap = map;
                if (git == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            git.close();
        }
        return hashMap;
    }

    @Override
    public String clone(String remoteRepository, boolean isAllBranches, String branchOrTag) {
        String string;
        block11: {
            String _xifexpression = null;
            _xifexpression = isAllBranches ? "\u662f" : "\u5426";
            LOG.info("\u514b\u9686\u8fdc\u7a0b\u4ed3\u5e93{},\u662f\u5426\u514b\u9686\u5168\u90e8\u5206\u652f{},\u514b\u9686\u5206\u652f\u6216\u6807\u7b7e{}", new Object[]{remoteRepository, _xifexpression, branchOrTag});
            File file = this.getRepository(remoteRepository);
            file.mkdirs();
            final CloneCommand clone = Git.cloneRepository().setURI(remoteRepository).setBare(false);
            if (isAllBranches) {
                clone.setCloneAllBranches(isAllBranches);
            } else {
                clone.setCloneAllBranches(isAllBranches);
                clone.setBranch(branchOrTag);
            }
            clone.setDirectory(file);
            this.credentials((TransportCommand<?, ?>)clone);
            Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return clone.call();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            try {
                Collection refs = git.lsRemote().setHeads(true).setRemote(remoteRepository).call();
                StringBuffer s = new StringBuffer();
                for (Ref ref : refs) {
                    s.append(ref.getName());
                    s.append("\n");
                }
                s.append("clone success");
                LOG.info("\u514b\u9686\u5b8c\u6210");
                string = s.toString();
                if (git == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            git.close();
        }
        return string;
    }

    @Override
    public String push(String remoteRepository, String name, String branch) {
        String string;
        block9: {
            final File file = this.getRepository(remoteRepository);
            Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            try {
                PushCommand _push = git.push();
                RefSpec _refSpec = new RefSpec(branch);
                PushCommand push = _push.setRefSpecs(new RefSpec[]{_refSpec}).setRemote(name);
                this.credentials((TransportCommand<?, ?>)push);
                Iterable infos = push.call();
                StringBuffer buffer = new StringBuffer();
                for (PushResult info : infos) {
                    buffer.append(info.getMessages());
                    buffer.append("\n");
                }
                string = buffer.toString();
                if (git == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            git.close();
        }
        return string;
    }

    @Override
    public String fetch(String remoteRepository, String branch) {
        try {
            File file = this.getRepository(remoteRepository);
            RefSpec _refSpec = new RefSpec(branch + ":" + branch);
            FetchCommand fetchCommand = Git.open((File)file).fetch().setRemote(remoteRepository).setRefSpecs(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RefSpec[]{_refSpec})));
            this.credentials((TransportCommand<?, ?>)fetchCommand);
            FetchResult result = fetchCommand.call();
            return result.getMessages();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public String fetchAll(String remoteRepository) {
        try {
            LOG.info("fetch\u4ed3\u5e93{}\u5168\u90e8\u5206\u652f", (Object)remoteRepository);
            File file = this.getRepository(remoteRepository);
            Collection refs = Git.lsRemoteRepository().setHeads(true).setRemote(remoteRepository).call();
            StringBuffer log = new StringBuffer("fetch:\n");
            for (Ref ref : refs) {
                String refStr = ref.getName();
                RefSpec _refSpec = new RefSpec(refStr + ":" + refStr);
                FetchCommand fetchCommand = Git.open((File)file).fetch().setRemote(remoteRepository).setRefSpecs(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RefSpec[]{_refSpec})));
                this.credentials((TransportCommand<?, ?>)fetchCommand);
                FetchResult result = fetchCommand.call();
                log.append(result.getMessages());
                log.append("\n");
            }
            log.append("Fetch success");
            LOG.info("fetch\u5b8c\u6210");
            return log.toString();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RevCommit commit(String remoteRepository, String[] files, String msg) {
        try {
            RevCommit _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            RevCommit _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                RevCommit _xblockexpression_1 = null;
                AddCommand addc = git.add();
                Consumer<String> _function = it -> {
                    try {
                        addc.addFilepattern(it).call();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                ((List)Conversions.doWrapArray((Object)files)).forEach(_function);
                _xtrycatchfinallyexpression = _xblockexpression_1 = git.commit().setMessage(msg).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public Map<String, String> status(String remoteRepository) {
        HashMap<String, String> hashMap;
        block8: {
            HashMap<String, String> map = new HashMap<String, String>();
            final File file = this.getRepository(remoteRepository);
            Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            try {
                Status status = git.status().call();
                map.put("Added", status.getAdded().toString());
                map.put("Changed", status.getChanged().toString());
                map.put("Conflicting", status.getConflicting().toString());
                map.put("ConflictingStageState", status.getConflictingStageState().toString());
                map.put("IgnoredNotInIndex", status.getIgnoredNotInIndex().toString());
                map.put("Missing", status.getMissing().toString());
                map.put("Modified", status.getModified().toString());
                map.put("Removed", status.getRemoved().toString());
                map.put("UntrackedFiles", status.getUntracked().toString());
                map.put("UntrackedFolders", status.getUntrackedFolders().toString());
                hashMap = map;
                if (git == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            git.close();
        }
        return hashMap;
    }

    public Ref branchCreate(String remoteRepository, String name) {
        try {
            Ref _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            Ref _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                _xtrycatchfinallyexpression = git.branchCreate().setName(name).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public List<String> branchDelete(String remoteRepository, String[] names) {
        try {
            List _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            List _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                _xtrycatchfinallyexpression = git.branchDelete().setBranchNames(names).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref branchRename(String remoteRepository, String oldName, String newName) {
        try {
            Ref _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            Ref _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                _xtrycatchfinallyexpression = git.branchRename().setNewName(newName).setOldName(oldName).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public List<String> branchList(String remoteRepository) {
        return this.branchList(remoteRepository, null);
    }

    @Override
    public List<String> branchList(String remoteRepository, ListBranchCommand.ListMode mode) {
        ArrayList arrayList;
        block9: {
            final File file = this.getRepository(remoteRepository);
            Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            try {
                ArrayList result = CollectionLiterals.newArrayList();
                ListBranchCommand blist = git.branchList();
                if (mode != null) {
                    blist.setListMode(mode);
                }
                Consumer<Ref> _function = it -> result.add(it.getName());
                blist.call().forEach(_function);
                arrayList = result;
                if (git == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            git.close();
        }
        return arrayList;
    }

    private boolean isBranchExist(Git git, String bname) {
        try {
            List refs = git.branchList().call();
            for (Ref ref : refs) {
                boolean _contains = ref.getName().contains(bname);
                if (!_contains) continue;
                return true;
            }
            return false;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void checkoutBranch(String remoteRepository, String name) {
        try {
            LOG.info("\u4ece\u4ed3\u5e93 {} checkout \u5206\u652f:{}", (Object)remoteRepository, (Object)name);
            FileRepositoryBuilder _fileRepositoryBuilder = new FileRepositoryBuilder();
            File _file = new File(remoteRepository);
            Repository repo = ((FileRepositoryBuilder)_fileRepositoryBuilder.setGitDir(_file)).build();
            try (Git git = new Git(repo);){
                boolean _isBranchExist = this.isBranchExist(git, name);
                if (_isBranchExist) {
                    git.checkout().setCreateBranch(false).setName(name).call();
                } else {
                    git.checkout().setCreateBranch(true).setName(name).setStartPoint("origin" + name).call();
                }
                git.pull().call();
            }
            LOG.info("checkout\u5b8c\u6210");
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void checkout(String remoteRepository, String name) {
        try {
            LOG.info("\u4ece\u4ed3\u5e93 {} checkout:{}", (Object)remoteRepository, (Object)name);
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                CheckoutCommand _checkout = git.checkout();
                CheckoutCommand ck = _checkout.setName(name);
                ck.call();
            }
            LOG.info("checkout\u5b8c\u6210");
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void merge(String remoteRepository, String srcName, String mergeBranch, String mgs) {
        try {
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Ref ref = git.checkout().setName(srcName).call();
                git.checkout().setName(mergeBranch).call();
                MergeCommand _setCommit = git.merge().include(ref).setCommit(true);
                MergeCommand merge = _setCommit.setFastForward(MergeCommand.FastForwardMode.NO_FF);
                merge.setMessage(mgs);
                merge.call();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void pull(String remoteRepository, String remoteBranch) {
        try {
            LOG.info("\u4ece\u4ed3\u5e93 {} pull => {}", (Object)remoteRepository, (Object)remoteBranch);
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                PullCommand _pull = git.pull();
                PullCommand pull = _pull.setRemoteBranchName(remoteBranch);
                this.credentials((TransportCommand<?, ?>)pull);
                pull.call();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void reset(String remoteRepository, String objectId) {
        try {
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Repository _repository = git.getRepository();
                RevWalk walk = new RevWalk(_repository);
                ObjectId objId = git.getRepository().resolve(objectId);
                RevCommit revCommit = walk.parseCommit((AnyObjectId)objId);
                String vision = revCommit.getParent(0).getName();
                git.reset().setMode(ResetCommand.ResetType.HARD).setRef(vision).call();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void revert(String remoteRepository, String commitId) {
        try {
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Repository _repository = git.getRepository();
                RevWalk walk = new RevWalk(_repository);
                RevCommit revCommit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)commitId));
                git.revert().include((AnyObjectId)revCommit).call();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public String logOne(String remoteRepository) {
        String string;
        block8: {
            LOG.info("\u4ece\u4ed3\u5e93 {} \u83b7\u53d6\u7b2c\u4e00\u6761\u65e5\u5fd7", (Object)remoteRepository);
            final File file = this.getRepository(remoteRepository);
            Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            try {
                Iterable log;
                Iterable _converted_log = log = git.log().call();
                RevCommit revCommit = ((RevCommit[])Conversions.unwrapArray((Object)_converted_log, RevCommit.class))[0];
                StringBuilder sb = new StringBuilder();
                sb.append(revCommit.getName()).append("\n");
                sb.append(revCommit.getCommitterIdent().getName()).append(":");
                sb.append(revCommit.getCommitterIdent().getEmailAddress()).append("\n");
                sb.append(revCommit.getCommitterIdent().getWhen()).append("\n");
                sb.append(revCommit.getFullMessage()).append("\n");
                string = sb.toString();
                if (git == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            git.close();
        }
        return string;
    }

    @Override
    public List<String> logAll(String remoteRepository) {
        ArrayList<String> arrayList;
        block9: {
            LOG.info("\u4ece\u4ed3\u5e93 {} \u83b7\u53d6\u6240\u6709\u65e5\u5fd7", (Object)remoteRepository);
            final File file = this.getRepository(remoteRepository);
            Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();
            try {
                Iterable log = git.log().call();
                ArrayList<String> logs = new ArrayList<String>();
                for (RevCommit revCommit : log) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(revCommit.getName()).append("\n");
                    sb.append(revCommit.getCommitterIdent().getName()).append(":");
                    sb.append(revCommit.getCommitterIdent().getEmailAddress()).append("\n");
                    sb.append(revCommit.getCommitterIdent().getWhen()).append("\n");
                    sb.append(revCommit.getFullMessage()).append("\n");
                    logs.add(sb.toString());
                }
                arrayList = logs;
                if (git == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            git.close();
        }
        return arrayList;
    }

    @Pure
    public TransportConfigCallback getSsh() {
        return this.ssh;
    }

    public void setSsh(TransportConfigCallback ssh) {
        this.ssh = ssh;
    }

    @Pure
    public CredentialsProvider getCp() {
        return this.cp;
    }

    public void setCp(CredentialsProvider cp) {
        this.cp = cp;
    }

    @Pure
    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public static enum StatusType {
        ALL,
        Added,
        Changed,
        Conflicting,
        ConflictingStageState,
        IgnoredNotInIndex,
        Missing,
        Modified,
        Removed,
        UntrackedFiles,
        UntrackedFolders;

    }
}

